/*
 * Decompiled with CFR 0.152.
 */
package com.mockrunner.mock.jms;

import com.mockrunner.base.NestedApplicationException;
import com.mockrunner.mock.jms.jms2_compat.Jms2MessageUtil;
import jakarta.jms.Destination;
import jakarta.jms.JMSException;
import jakarta.jms.Message;
import jakarta.jms.MessageFormatException;
import jakarta.jms.MessageNotWriteableException;
import java.io.Serializable;
import java.io.UnsupportedEncodingException;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import java.util.Vector;

public class MockMessage
implements Message,
Cloneable,
Serializable {
    private String messageId = null;
    private long timestamp = System.currentTimeMillis();
    private String correlationId;
    private Destination replyTo;
    private Destination destination;
    private int deliveryMode = 2;
    private boolean redelivered = false;
    private String type;
    private long expiration = 0L;
    private int priority = 4;
    private boolean acknowledged = false;
    private Map properties = new HashMap();
    private boolean isInWriteMode = true;
    private boolean isInWriteModeProperties = true;
    private Long jms2DeliveryTime;

    public boolean isAcknowledged() {
        return this.acknowledged;
    }

    public String getJMSMessageID() throws JMSException {
        return this.messageId;
    }

    public void setJMSMessageID(String messageId) throws JMSException {
        this.messageId = messageId;
    }

    public long getJMSTimestamp() throws JMSException {
        return this.timestamp;
    }

    public void setJMSTimestamp(long timestamp) throws JMSException {
        this.timestamp = timestamp;
    }

    public byte[] getJMSCorrelationIDAsBytes() throws JMSException {
        if (null == this.correlationId) {
            return null;
        }
        try {
            return this.correlationId.getBytes("ISO-8859-1");
        }
        catch (UnsupportedEncodingException exc) {
            throw new JMSException(exc.getMessage());
        }
    }

    public void setJMSCorrelationIDAsBytes(byte[] correlationId) throws JMSException {
        try {
            this.correlationId = null == correlationId ? null : new String(correlationId, "ISO-8859-1");
        }
        catch (UnsupportedEncodingException exc) {
            throw new JMSException(exc.getMessage());
        }
    }

    public void setJMSCorrelationID(String correlationId) throws JMSException {
        this.correlationId = correlationId;
    }

    public String getJMSCorrelationID() throws JMSException {
        return this.correlationId;
    }

    public Destination getJMSReplyTo() throws JMSException {
        return this.replyTo;
    }

    public void setJMSReplyTo(Destination replyTo) throws JMSException {
        this.replyTo = replyTo;
    }

    public Destination getJMSDestination() throws JMSException {
        return this.destination;
    }

    public void setJMSDestination(Destination destination) throws JMSException {
        this.destination = destination;
    }

    public int getJMSDeliveryMode() throws JMSException {
        return this.deliveryMode;
    }

    public void setJMSDeliveryMode(int deliveryMode) throws JMSException {
        this.deliveryMode = deliveryMode;
    }

    public boolean getJMSRedelivered() throws JMSException {
        return this.redelivered;
    }

    public void setJMSRedelivered(boolean redelivered) throws JMSException {
        this.redelivered = redelivered;
    }

    public String getJMSType() throws JMSException {
        return this.type;
    }

    public void setJMSType(String type) throws JMSException {
        this.type = type;
    }

    public long getJMSExpiration() throws JMSException {
        return this.expiration;
    }

    public void setJMSExpiration(long expiration) throws JMSException {
        this.expiration = expiration;
    }

    public long getJMSDeliveryTime() throws JMSException {
        return this.jms2DeliveryTime;
    }

    public void setJMSDeliveryTime(long deliveryTime) throws JMSException {
        this.jms2DeliveryTime = deliveryTime;
    }

    public int getJMSPriority() throws JMSException {
        return this.priority;
    }

    public void setJMSPriority(int priority) throws JMSException {
        this.priority = priority;
    }

    public void clearProperties() throws JMSException {
        this.isInWriteModeProperties = true;
        this.properties.clear();
    }

    public boolean propertyExists(String name) throws JMSException {
        return this.properties.containsKey(name);
    }

    public boolean getBooleanProperty(String name) throws JMSException {
        Object value = this.getObjectProperty(name);
        if (value == null) {
            return false;
        }
        if (value instanceof String) {
            return Boolean.valueOf((String)value);
        }
        if (value instanceof Boolean) {
            return (Boolean)value;
        }
        throw new MessageFormatException("Cannot convert property " + name + " of type " + value.getClass().getName() + " to boolean");
    }

    public byte getByteProperty(String name) throws JMSException {
        Object value = this.getObjectProperty(name);
        if (value == null) {
            throw new MessageFormatException(this.getNullPropertyMessage(name));
        }
        if (value instanceof String) {
            return Byte.valueOf((String)value);
        }
        if (value instanceof Byte) {
            return ((Number)value).byteValue();
        }
        throw new MessageFormatException("Cannot convert property " + name + " of type " + value.getClass().getName() + " to byte");
    }

    public short getShortProperty(String name) throws JMSException {
        Object value = this.getObjectProperty(name);
        if (value == null) {
            throw new MessageFormatException(this.getNullPropertyMessage(name));
        }
        if (value instanceof String) {
            return Short.valueOf((String)value);
        }
        if (value instanceof Short || value instanceof Byte) {
            return ((Number)value).shortValue();
        }
        throw new MessageFormatException("Cannot convert property " + name + " of type " + value.getClass().getName() + " to short");
    }

    public int getIntProperty(String name) throws JMSException {
        Object value = this.getObjectProperty(name);
        if (value == null) {
            throw new MessageFormatException(this.getNullPropertyMessage(name));
        }
        if (value instanceof String) {
            return Integer.valueOf((String)value);
        }
        if (value instanceof Integer || value instanceof Short || value instanceof Byte) {
            return ((Number)value).intValue();
        }
        throw new MessageFormatException("Cannot convert property " + name + " of type " + value.getClass().getName() + " to int");
    }

    public long getLongProperty(String name) throws JMSException {
        Object value = this.getObjectProperty(name);
        if (value == null) {
            throw new MessageFormatException(this.getNullPropertyMessage(name));
        }
        if (value instanceof String) {
            return Long.valueOf((String)value);
        }
        if (value instanceof Long || value instanceof Integer || value instanceof Short || value instanceof Byte) {
            return ((Number)value).longValue();
        }
        throw new MessageFormatException("Cannot convert property " + name + " of type " + value.getClass().getName() + " to long");
    }

    public float getFloatProperty(String name) throws JMSException {
        Object value = this.getObjectProperty(name);
        if (value == null) {
            throw new MessageFormatException(this.getNullPropertyMessage(name));
        }
        if (value instanceof String) {
            return Float.valueOf((String)value).floatValue();
        }
        if (value instanceof Float) {
            return ((Number)value).floatValue();
        }
        throw new MessageFormatException("Cannot convert property " + name + " of type " + value.getClass().getName() + " to float");
    }

    public double getDoubleProperty(String name) throws JMSException {
        Object value = this.getObjectProperty(name);
        if (value == null) {
            throw new MessageFormatException(this.getNullPropertyMessage(name));
        }
        if (value instanceof String) {
            return Double.valueOf((String)value);
        }
        if (value instanceof Double || value instanceof Float) {
            return ((Number)value).doubleValue();
        }
        throw new MessageFormatException("Cannot convert property " + name + " of type " + value.getClass().getName() + " to double");
    }

    public String getStringProperty(String name) throws JMSException {
        Object value = this.getObjectProperty(name);
        if (null == value) {
            return null;
        }
        return value.toString();
    }

    public Object getObjectProperty(String name) throws JMSException {
        return this.properties.get(name);
    }

    public Enumeration getPropertyNames() throws JMSException {
        return new Vector(this.properties.keySet()).elements();
    }

    public void setBooleanProperty(String name, boolean value) throws JMSException {
        this.setObjectProperty(name, value);
    }

    public void setByteProperty(String name, byte value) throws JMSException {
        this.setObjectProperty(name, value);
    }

    public void setShortProperty(String name, short value) throws JMSException {
        this.setObjectProperty(name, value);
    }

    public void setIntProperty(String name, int value) throws JMSException {
        this.setObjectProperty(name, value);
    }

    public void setLongProperty(String name, long value) throws JMSException {
        this.setObjectProperty(name, value);
    }

    public void setFloatProperty(String name, float value) throws JMSException {
        this.setObjectProperty(name, Float.valueOf(value));
    }

    public void setDoubleProperty(String name, double value) throws JMSException {
        this.setObjectProperty(name, value);
    }

    public void setStringProperty(String name, String value) throws JMSException {
        this.setObjectProperty(name, value);
    }

    public void setObjectProperty(String name, Object object) throws JMSException {
        if (!this.isInWriteModeProperties) {
            throw new MessageNotWriteableException("Message is in read mode");
        }
        if (null == name || name.length() <= 0) {
            throw new IllegalArgumentException("Property names must not be null or empty strings");
        }
        if (null == object) {
            return;
        }
        if (object instanceof String || object instanceof Number || object instanceof Boolean) {
            this.properties.put(name, object);
            return;
        }
        throw new MessageFormatException(object.getClass().getName() + " not a valid type");
    }

    public void acknowledge() throws JMSException {
        this.acknowledged = true;
    }

    public void clearBody() throws JMSException {
        this.isInWriteMode = true;
    }

    public <T> T getBody(Class<T> c) throws JMSException {
        return Jms2MessageUtil.getBody(this, c);
    }

    public boolean isBodyAssignableTo(Class c) throws JMSException {
        return Jms2MessageUtil.isBodyAssignableTo(this, c);
    }

    public void setReadOnly(boolean isReadOnly) {
        this.isInWriteMode = !isReadOnly;
    }

    public void setReadOnlyProperties(boolean isReadOnly) {
        this.isInWriteModeProperties = !isReadOnly;
    }

    public Object clone() {
        try {
            MockMessage clone = (MockMessage)super.clone();
            clone.properties = new HashMap(this.properties);
            return clone;
        }
        catch (CloneNotSupportedException exc) {
            throw new NestedApplicationException((Throwable)exc);
        }
    }

    protected boolean isInWriteMode() {
        return this.isInWriteMode;
    }

    protected String getNullPropertyMessage(String name) {
        return String.format("Property %s was null", name);
    }
}

