/*
 * Decompiled with CFR 0.152.
 */
package com.mockrunner.mock.jms;

import com.mockrunner.mock.jms.MockConnection;
import jakarta.jms.InvalidSelectorException;
import jakarta.jms.JMSException;
import jakarta.jms.Message;
import jakarta.jms.MessageConsumer;
import jakarta.jms.MessageListener;
import java.io.Serializable;
import java.util.Date;
import org.activemq.filter.mockrunner.Filter;
import org.activemq.selector.mockrunner.SelectorParser;

public abstract class MockMessageConsumer
implements MessageConsumer,
Serializable {
    private MockConnection connection;
    private String messageSelector;
    private Filter messageSelectorFilter;
    private boolean closed;
    private MessageListener messageListener;

    public MockMessageConsumer(MockConnection connection, String messageSelector) {
        this.connection = connection;
        this.messageSelector = messageSelector;
        this.parseMessageSelector();
        this.closed = false;
        this.messageListener = null;
    }

    private void parseMessageSelector() {
        if (null == this.messageSelector || this.messageSelector.length() == 0) {
            this.messageSelectorFilter = null;
        } else {
            try {
                this.messageSelectorFilter = new SelectorParser().parse(this.messageSelector);
            }
            catch (InvalidSelectorException exc) {
                throw new RuntimeException("Error parsing message selector: " + exc.getMessage());
            }
        }
    }

    public boolean isClosed() {
        return this.closed;
    }

    public boolean canConsume(Message message) {
        if (this.messageListener == null) {
            return false;
        }
        if (this.isClosed()) {
            return false;
        }
        return this.matchesMessageSelector(message);
    }

    public void receiveMessage(Message message) {
        if (null == this.messageListener) {
            return;
        }
        this.messageListener.onMessage(message);
    }

    public String getMessageSelector() throws JMSException {
        this.connection.throwJMSException();
        return this.messageSelector;
    }

    public MessageListener getMessageListener() throws JMSException {
        this.connection.throwJMSException();
        return this.messageListener;
    }

    public void setMessageListener(MessageListener messageListener) throws JMSException {
        this.connection.throwJMSException();
        this.messageListener = messageListener;
    }

    protected abstract void waitOnMessage(long var1);

    public Message receive(long timeout) throws JMSException {
        if (timeout == 0L) {
            return this.receive();
        }
        this.getConnection().throwJMSException();
        Message message = null;
        Date waitTill = new Date(new Date().getTime() + timeout);
        while (true) {
            if ((message = this.receiveNoWait()) != null) {
                return message;
            }
            timeout = waitTill.getTime() - new Date().getTime();
            if (timeout <= 0L) break;
            this.waitOnMessage(timeout);
        }
        return null;
    }

    public Message receive() throws JMSException {
        this.getConnection().throwJMSException();
        Message message = null;
        while ((message = this.receiveNoWait()) == null) {
            this.waitOnMessage(0L);
        }
        return message;
    }

    public void close() throws JMSException {
        this.connection.throwJMSException();
        this.closed = true;
    }

    private boolean matchesMessageSelector(Message message) {
        if (!this.connection.getConfigurationManager().getUseMessageSelectors()) {
            return true;
        }
        if (this.messageSelectorFilter == null) {
            return true;
        }
        try {
            return this.messageSelectorFilter.matches(message);
        }
        catch (JMSException exc) {
            throw new RuntimeException(exc.getMessage());
        }
    }

    protected Filter getMessageFilter() {
        return this.messageSelectorFilter;
    }

    protected MockConnection getConnection() {
        return this.connection;
    }
}

