/*
 * Decompiled with CFR 0.152.
 */
package com.mockrunner.mock.jms;

import com.mockrunner.mock.jms.MockMessage;
import jakarta.jms.JMSException;
import jakarta.jms.MessageNotWriteableException;
import jakarta.jms.TextMessage;

public class MockTextMessage
extends MockMessage
implements TextMessage {
    private String text;

    public MockTextMessage() {
        this(null);
    }

    public MockTextMessage(String text) {
        this.text = text;
    }

    public void setText(String text) throws JMSException {
        if (!this.isInWriteMode()) {
            throw new MessageNotWriteableException("Message is in read mode");
        }
        this.text = text;
    }

    public String getText() throws JMSException {
        return this.text;
    }

    public String toString() {
        return this.getClass().getName() + ": " + this.text;
    }

    @Override
    public void clearBody() throws JMSException {
        super.clearBody();
        this.text = null;
    }

    public boolean equals(Object otherObject) {
        if (null == otherObject) {
            return false;
        }
        if (!(otherObject instanceof MockTextMessage)) {
            return false;
        }
        MockTextMessage otherMessage = (MockTextMessage)otherObject;
        if (null == this.text && null == otherMessage.text) {
            return true;
        }
        return this.text.equals(otherMessage.text);
    }

    public int hashCode() {
        if (null == this.text) {
            return 0;
        }
        return this.text.hashCode();
    }
}

