/*
 * Decompiled with CFR 0.152.
 */
package com.mockrunner.mock.jms;

import com.mockrunner.mock.jms.MockConnection;
import com.mockrunner.mock.jms.MockMessageConsumer;
import com.mockrunner.mock.jms.MockSession;
import com.mockrunner.mock.jms.MockTopic;
import jakarta.jms.JMSException;
import jakarta.jms.Message;
import jakarta.jms.Topic;
import jakarta.jms.TopicSubscriber;

public class MockTopicSubscriber
extends MockMessageConsumer
implements TopicSubscriber {
    private MockSession session;
    private MockTopic topic;
    private boolean noLocal;
    private String name;
    private boolean isDurable;

    public MockTopicSubscriber(MockConnection connection, MockSession session, MockTopic topic) {
        this(connection, session, topic, null, false);
    }

    public MockTopicSubscriber(MockConnection connection, MockSession session, MockTopic topic, String messageSelector, boolean noLocal) {
        super(connection, messageSelector);
        this.session = session;
        this.topic = topic;
        this.noLocal = noLocal;
        this.name = null;
        this.isDurable = false;
    }

    public boolean isDurable() {
        return this.isDurable;
    }

    public void setDurable(boolean isDurable) {
        this.isDurable = isDurable;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public Topic getTopic() throws JMSException {
        this.getConnection().throwJMSException();
        return this.topic;
    }

    public boolean getNoLocal() throws JMSException {
        this.getConnection().throwJMSException();
        return this.noLocal;
    }

    public Message receiveNoWait() throws JMSException {
        this.getConnection().throwJMSException();
        if (this.isClosed()) {
            throw new JMSException("Subscriber is closed");
        }
        if (this.topic.isEmpty()) {
            return null;
        }
        Message message = !this.getConnection().getConfigurationManager().getUseMessageSelectors() || null == this.getMessageFilter() ? this.topic.getMessage() : this.topic.getMatchingMessage(this.getMessageFilter());
        if (null == message) {
            return null;
        }
        if (this.session.isAutoAcknowledge()) {
            message.acknowledge();
        }
        return message;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void waitOnMessage(long timeout) {
        try {
            MockTopic mockTopic = this.topic;
            synchronized (mockTopic) {
                this.topic.wait(10L);
            }
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }
}

