/*
 * Decompiled with CFR 0.152.
 */
package com.mockrunner.mock.jms.jms2_compat;

import com.mockrunner.mock.jms.jms2_compat.Callback;
import com.mockrunner.mock.jms.jms2_compat.Jms2Context;
import com.mockrunner.mock.jms.jms2_compat.Jms2MessageUtil;
import com.mockrunner.mock.jms.jms2_compat.Jms2Util;
import com.mockrunner.mock.jms.jms2_compat.ObjectsUtil;
import jakarta.jms.JMSConsumer;
import jakarta.jms.JMSException;
import jakarta.jms.JMSRuntimeException;
import jakarta.jms.Message;
import jakarta.jms.MessageConsumer;
import jakarta.jms.MessageFormatException;
import jakarta.jms.MessageListener;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

public class Jms2Consumer
implements JMSConsumer {
    private final MessageConsumer consumer;
    private final List<Message> acknowledgeMessages = new ArrayList<Message>();
    private final Jms2Context context;

    protected Jms2Consumer(Jms2Context context, MessageConsumer consumer) {
        this.consumer = Objects.requireNonNull(consumer);
        this.context = Objects.requireNonNull(context);
    }

    public String getMessageSelector() {
        return Jms2Util.getMessageSelector(this.consumer);
    }

    public MessageListener getMessageListener() throws JMSRuntimeException {
        return Jms2Util.getMessageListener(this.consumer);
    }

    public void setMessageListener(MessageListener listener) throws JMSRuntimeException {
        Jms2Util.setMessageListener(this.consumer, listener);
        if (this.context.getAutoStart()) {
            this.context.start();
        }
    }

    public Message receive() {
        return this.add(Jms2Util.receive(this.consumer));
    }

    public Message receive(long timeout) {
        return this.add(Jms2Util.receive(this.consumer, timeout));
    }

    public Message receiveNoWait() {
        return this.add(Jms2Util.receiveNoWait(this.consumer));
    }

    public void close() {
        Jms2Util.close(this.consumer);
    }

    public <T> T receiveBody(Class<T> c) {
        Message msg = this.receive();
        if (msg == null) {
            return null;
        }
        this.add(msg);
        return this.getBody(msg, c);
    }

    private <T> T getBody(Message msg, Class<T> type) {
        try {
            return Jms2MessageUtil.getBody(msg, type);
        }
        catch (MessageFormatException ex) {
            throw Jms2Util.uncheck(ex);
        }
        catch (JMSException ex) {
            throw Jms2Util.uncheck(ex);
        }
    }

    public <T> T receiveBody(Class<T> type, long timeout) {
        Message msg = this.receive(timeout);
        if (ObjectsUtil.isNull(msg)) {
            return null;
        }
        return this.getBody(msg, type);
    }

    public <T> T receiveBodyNoWait(Class<T> type) {
        Message msg = this.receiveNoWait();
        if (ObjectsUtil.isNull(msg)) {
            return null;
        }
        return this.getBody(msg, type);
    }

    private <M extends Message> M add(M message) {
        if (message == null) {
            return null;
        }
        if (this.context.getSessionMode() == 2) {
            this.acknowledgeMessages.add(message);
        }
        return message;
    }

    protected void acknowledge() {
        for (final Message msg : this.acknowledgeMessages) {
            Jms2Util.execute(new Callback<Void>(){

                @Override
                public Void execute() throws JMSException {
                    msg.acknowledge();
                    return null;
                }
            });
        }
        this.acknowledgeMessages.clear();
    }
}

