/*
 * Decompiled with CFR 0.152.
 */
package com.mockrunner.mock.jms.jms2_compat;

import com.mockrunner.mock.jms.jms2_compat.Callback;
import com.mockrunner.mock.jms.jms2_compat.Jms2Consumer;
import com.mockrunner.mock.jms.jms2_compat.Jms2MessageFactory;
import com.mockrunner.mock.jms.jms2_compat.Jms2Producer;
import com.mockrunner.mock.jms.jms2_compat.Jms2Util;
import jakarta.jms.BytesMessage;
import jakarta.jms.Connection;
import jakarta.jms.ConnectionMetaData;
import jakarta.jms.Destination;
import jakarta.jms.ExceptionListener;
import jakarta.jms.JMSConsumer;
import jakarta.jms.JMSContext;
import jakarta.jms.JMSException;
import jakarta.jms.JMSProducer;
import jakarta.jms.MapMessage;
import jakarta.jms.Message;
import jakarta.jms.ObjectMessage;
import jakarta.jms.Queue;
import jakarta.jms.QueueBrowser;
import jakarta.jms.Session;
import jakarta.jms.StreamMessage;
import jakarta.jms.TemporaryQueue;
import jakarta.jms.TemporaryTopic;
import jakarta.jms.TextMessage;
import jakarta.jms.Topic;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

public final class Jms2Context
implements JMSContext {
    private boolean autoStart;
    private boolean started;
    private final Session session;
    private final Connection connection;
    private final List<Jms2Consumer> consumers = new ArrayList<Jms2Consumer>();

    public Jms2Context(Connection connection, Session session) {
        this.connection = Objects.requireNonNull(connection);
        this.session = Objects.requireNonNull(session);
    }

    public JMSContext createContext(final int sessionMode) {
        return Jms2Util.execute(new Callback<JMSContext>(){

            @Override
            public JMSContext execute() throws JMSException {
                Session newSession = Jms2Context.this.connection.createSession(sessionMode == 0, sessionMode);
                return new Jms2Context(Jms2Context.this.connection, newSession);
            }
        });
    }

    public JMSProducer createProducer() {
        return new Jms2Producer(this.session);
    }

    public String getClientID() {
        return Jms2Util.getClientID(this.connection);
    }

    public void setClientID(String clientID) {
        Jms2Util.setClientID(this.connection, clientID);
    }

    public ConnectionMetaData getMetaData() {
        return Jms2Util.getMetaData(this.connection);
    }

    public ExceptionListener getExceptionListener() {
        return Jms2Util.getExceptionListener(this.connection);
    }

    public void setExceptionListener(ExceptionListener listener) {
        Jms2Util.setExceptionListener(this.connection, listener);
    }

    public void start() {
        if (this.started) {
            this.stop();
        }
        Jms2Util.start(this.connection);
        this.started = true;
    }

    public void stop() {
        Jms2Util.stop(this.connection);
        this.started = false;
    }

    public void setAutoStart(boolean autoStart) {
        this.autoStart = autoStart;
    }

    public boolean getAutoStart() {
        return this.autoStart;
    }

    public void close() {
        Jms2Util.close(this.connection, this.session);
    }

    public BytesMessage createBytesMessage() {
        return Jms2MessageFactory.createBytesMessage(this.session);
    }

    public MapMessage createMapMessage() {
        return Jms2MessageFactory.createMapMessage(this.session);
    }

    public Message createMessage() {
        return Jms2MessageFactory.createMessage(this.session);
    }

    public ObjectMessage createObjectMessage() {
        return Jms2MessageFactory.createObjectMessage(this.session);
    }

    public ObjectMessage createObjectMessage(Serializable object) {
        return Jms2MessageFactory.createObjectMessage(this.session, object);
    }

    public StreamMessage createStreamMessage() {
        return Jms2MessageFactory.createStreamMessage(this.session);
    }

    public TextMessage createTextMessage() {
        return Jms2MessageFactory.createTextMessage(this.session);
    }

    public TextMessage createTextMessage(String text) {
        return Jms2MessageFactory.createTextMessage(this.session, text);
    }

    public boolean getTransacted() {
        return Jms2Util.getTransacted(this.session);
    }

    public int getSessionMode() {
        return Jms2Util.getSessionMode(this.session);
    }

    public void commit() {
        Jms2Util.commit(this.session);
    }

    public void rollback() {
        Jms2Util.rollback(this.session);
    }

    public void recover() {
        Jms2Util.recover(this.session);
    }

    public JMSConsumer createConsumer(Destination destination) {
        return Jms2Util.createConsumer(this, destination);
    }

    public JMSConsumer createConsumer(Destination destination, String selector) {
        return Jms2Util.createConsumer(this, destination, selector);
    }

    public JMSConsumer createConsumer(Destination destination, String selector, boolean arg2) {
        return Jms2Util.createConsumer(this, destination, selector, arg2);
    }

    public Queue createQueue(String queueName) {
        return Jms2Util.createQueue(this.session, queueName);
    }

    public Topic createTopic(String topicName) {
        return Jms2Util.createTopic(this.session, topicName);
    }

    public JMSConsumer createDurableConsumer(Topic topic, String name) {
        return Jms2Util.createDurableConsumer(this, topic, name);
    }

    public JMSConsumer createDurableConsumer(Topic topic, String name, String selector, boolean noLocal) {
        return Jms2Util.createDurableConsumer(this, topic, name, selector, noLocal);
    }

    public JMSConsumer createSharedDurableConsumer(Topic topic, String name) {
        return Jms2Util.createDurableConsumer(this, topic, name);
    }

    public JMSConsumer createSharedDurableConsumer(Topic topic, String name, String selector) {
        return Jms2Util.createSharedDurableConsumer(this, topic, name, selector);
    }

    public JMSConsumer createSharedConsumer(Topic topic, String name) {
        return Jms2Util.createSharedConsumer(this, topic, name);
    }

    public JMSConsumer createSharedConsumer(Topic topic, String name, String selector) {
        return Jms2Util.createSharedConsumer(this, topic, name, selector);
    }

    public QueueBrowser createBrowser(Queue queue) {
        return Jms2Util.createBrowser(this.session, queue);
    }

    public QueueBrowser createBrowser(Queue queue, String selector) {
        return Jms2Util.createBrowser(this.session, queue, selector);
    }

    public TemporaryQueue createTemporaryQueue() {
        return Jms2Util.createTemporaryQueue(this.session);
    }

    public TemporaryTopic createTemporaryTopic() {
        return Jms2Util.createTemporaryTopic(this.session);
    }

    public void unsubscribe(String name) {
        Jms2Util.unsubscribe(this.session, name);
    }

    public void acknowledge() {
        for (Jms2Consumer consumer : this.consumers) {
            consumer.acknowledge();
        }
    }

    public Session getSession() {
        return this.session;
    }

    Jms2Consumer addConsumer(Jms2Consumer consumer) {
        this.consumers.add(consumer);
        return consumer;
    }
}

