/*
 * Decompiled with CFR 0.152.
 */
package com.mockrunner.mock.jms.jms2_compat;

import com.mockrunner.mock.jms.jms2_compat.Jms2MessageUtil;
import jakarta.jms.Destination;
import jakarta.jms.JMSException;
import jakarta.jms.Message;
import java.util.Enumeration;
import java.util.Objects;

public class Jms2Message
implements Message {
    private final Message delegate;
    private Long jms2DeliveryTime;

    public Jms2Message(Message delegate) {
        if (this.getClass().isInstance(delegate)) {
            throw new IllegalArgumentException("Unable to wrap a Jms2Message");
        }
        this.delegate = Objects.requireNonNull(delegate);
    }

    public String getJMSMessageID() throws JMSException {
        return this.delegate.getJMSMessageID();
    }

    public void setJMSMessageID(String id) throws JMSException {
        this.delegate.setJMSMessageID(id);
    }

    public long getJMSTimestamp() throws JMSException {
        return this.delegate.getJMSTimestamp();
    }

    public void setJMSTimestamp(long timestamp) throws JMSException {
        this.delegate.setJMSTimestamp(timestamp);
    }

    public byte[] getJMSCorrelationIDAsBytes() throws JMSException {
        return this.delegate.getJMSCorrelationIDAsBytes();
    }

    public void setJMSCorrelationIDAsBytes(byte[] correlationID) throws JMSException {
        this.delegate.setJMSCorrelationIDAsBytes(correlationID);
    }

    public void setJMSCorrelationID(String correlationID) throws JMSException {
        this.delegate.setJMSCorrelationID(correlationID);
    }

    public String getJMSCorrelationID() throws JMSException {
        return this.delegate.getJMSCorrelationID();
    }

    public Destination getJMSReplyTo() throws JMSException {
        return this.delegate.getJMSReplyTo();
    }

    public void setJMSReplyTo(Destination replyTo) throws JMSException {
        this.delegate.setJMSReplyTo(replyTo);
    }

    public Destination getJMSDestination() throws JMSException {
        return this.delegate.getJMSDestination();
    }

    public void setJMSDestination(Destination destination) throws JMSException {
        this.delegate.setJMSDestination(destination);
    }

    public int getJMSDeliveryMode() throws JMSException {
        return this.delegate.getJMSDeliveryMode();
    }

    public void setJMSDeliveryMode(int deliveryMode) throws JMSException {
        this.delegate.setJMSDeliveryMode(deliveryMode);
    }

    public boolean getJMSRedelivered() throws JMSException {
        return this.delegate.getJMSRedelivered();
    }

    public void setJMSRedelivered(boolean redelivered) throws JMSException {
        this.delegate.setJMSRedelivered(redelivered);
    }

    public String getJMSType() throws JMSException {
        return this.delegate.getJMSType();
    }

    public void setJMSType(String type) throws JMSException {
        this.delegate.setJMSType(type);
    }

    public long getJMSExpiration() throws JMSException {
        return this.delegate.getJMSExpiration();
    }

    public void setJMSExpiration(long expiration) throws JMSException {
        this.delegate.setJMSExpiration(expiration);
    }

    public long getJMSDeliveryTime() throws JMSException {
        return this.jms2DeliveryTime;
    }

    public void setJMSDeliveryTime(long deliveryTime) throws JMSException {
        this.jms2DeliveryTime = deliveryTime;
    }

    public int getJMSPriority() throws JMSException {
        return this.delegate.getJMSPriority();
    }

    public void setJMSPriority(int priority) throws JMSException {
        this.delegate.setJMSPriority(priority);
    }

    public void clearProperties() throws JMSException {
        this.delegate.clearProperties();
    }

    public boolean propertyExists(String name) throws JMSException {
        return this.delegate.propertyExists(name);
    }

    public boolean getBooleanProperty(String name) throws JMSException {
        return this.delegate.getBooleanProperty(name);
    }

    public byte getByteProperty(String name) throws JMSException {
        return this.delegate.getByteProperty(name);
    }

    public short getShortProperty(String name) throws JMSException {
        return this.delegate.getShortProperty(name);
    }

    public int getIntProperty(String name) throws JMSException {
        return this.delegate.getIntProperty(name);
    }

    public long getLongProperty(String name) throws JMSException {
        return this.delegate.getLongProperty(name);
    }

    public float getFloatProperty(String name) throws JMSException {
        return this.delegate.getFloatProperty(name);
    }

    public double getDoubleProperty(String name) throws JMSException {
        return this.delegate.getDoubleProperty(name);
    }

    public String getStringProperty(String name) throws JMSException {
        return this.delegate.getStringProperty(name);
    }

    public Object getObjectProperty(String name) throws JMSException {
        return this.delegate.getObjectProperty(name);
    }

    public Enumeration getPropertyNames() throws JMSException {
        return this.delegate.getPropertyNames();
    }

    public void setBooleanProperty(String arg0, boolean arg1) throws JMSException {
        this.delegate.setBooleanProperty(arg0, arg1);
    }

    public void setByteProperty(String arg0, byte arg1) throws JMSException {
        this.delegate.setByteProperty(arg0, arg1);
    }

    public void setShortProperty(String arg0, short arg1) throws JMSException {
        this.delegate.setShortProperty(arg0, arg1);
    }

    public void setIntProperty(String arg0, int arg1) throws JMSException {
        this.delegate.setIntProperty(arg0, arg1);
    }

    public void setLongProperty(String arg0, long arg1) throws JMSException {
        this.delegate.setLongProperty(arg0, arg1);
    }

    public void setFloatProperty(String arg0, float arg1) throws JMSException {
        this.delegate.setFloatProperty(arg0, arg1);
    }

    public void setDoubleProperty(String arg0, double arg1) throws JMSException {
        this.delegate.setDoubleProperty(arg0, arg1);
    }

    public void setStringProperty(String arg0, String arg1) throws JMSException {
        this.delegate.setStringProperty(arg0, arg1);
    }

    public void setObjectProperty(String arg0, Object arg1) throws JMSException {
        this.delegate.setObjectProperty(arg0, arg1);
    }

    public void acknowledge() throws JMSException {
        this.delegate.acknowledge();
    }

    public void clearBody() throws JMSException {
        this.delegate.clearBody();
    }

    public <T> T getBody(Class<T> c) throws JMSException {
        return Jms2MessageUtil.getBody(this.delegate, c);
    }

    public boolean isBodyAssignableTo(Class c) throws JMSException {
        return Jms2MessageUtil.isBodyAssignableTo(this.delegate, c);
    }

    public Message getDelegate() {
        return this.delegate;
    }
}

