/*
 * Decompiled with CFR 0.152.
 */
package com.mockrunner.mock.jms.jms2_compat;

import com.mockrunner.mock.jms.jms2_compat.Callback;
import com.mockrunner.mock.jms.jms2_compat.Jms2Util;
import jakarta.jms.BytesMessage;
import jakarta.jms.JMSException;
import jakarta.jms.MapMessage;
import jakarta.jms.Message;
import jakarta.jms.MessageFormatException;
import jakarta.jms.ObjectMessage;
import jakarta.jms.Session;
import jakarta.jms.StreamMessage;
import jakarta.jms.TextMessage;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public final class Jms2MessageUtil {
    private static void acknowledge(final Message m) {
        Jms2Util.execute(new Callback<Void>(){

            @Override
            public Void execute() throws JMSException {
                m.acknowledge();
                return null;
            }
        });
    }

    static void acknowledge(Session session, List<Message> acknowledgeMessages) {
        if (!Jms2Util.isClientAcknowledge(session)) {
            return;
        }
        for (Message m : acknowledgeMessages) {
            Jms2MessageUtil.acknowledge(m);
        }
    }

    private Jms2MessageUtil() {
    }

    static boolean isTextMessage(Message message, Class type) {
        return TextMessage.class.isInstance(message) && String.class.isAssignableFrom(type);
    }

    static boolean isBytesMessage(Message message, Class type) {
        return BytesMessage.class.isInstance(message) && byte[].class.isAssignableFrom(type);
    }

    static boolean isObjectMessage(Message message, Class type) {
        return ObjectMessage.class.isInstance(message) && Serializable.class.isAssignableFrom(type);
    }

    static boolean isMapMessage(Message message, Class type) {
        return MapMessage.class.isInstance(message) && Map.class.isAssignableFrom(type);
    }

    static boolean isPlainMessage(Message message) {
        List<Class> types = Arrays.asList(TextMessage.class, BytesMessage.class, MapMessage.class, ObjectMessage.class, StreamMessage.class);
        for (Class c : types) {
            if (!c.isInstance(message)) continue;
            return false;
        }
        return true;
    }

    public static boolean isBodyAssignableTo(Message message, Class type) {
        if (StreamMessage.class.isInstance(message)) {
            return false;
        }
        return Jms2MessageUtil.isPlainMessage(message) || Jms2MessageUtil.isTextMessage(message, type) || Jms2MessageUtil.isBytesMessage(message, type) || Jms2MessageUtil.isObjectMessage(message, type) || Jms2MessageUtil.isMapMessage(message, type);
    }

    public static <T> T getBody(Message message, Class<T> type) throws JMSException {
        if (StreamMessage.class.isInstance(message)) {
            throw new MessageFormatException("Body cannot be extracted from StreamMessage see JMS 2.0 Spec");
        }
        if (Jms2MessageUtil.isTextMessage(message, type)) {
            return (T)((TextMessage)TextMessage.class.cast(message)).getText();
        }
        if (Jms2MessageUtil.isObjectMessage(message, type)) {
            return (T)((ObjectMessage)ObjectMessage.class.cast(message)).getObject();
        }
        if (Jms2MessageUtil.isBytesMessage(message, type)) {
            BytesMessage bmsg = (BytesMessage)BytesMessage.class.cast(message);
            int length = (int)bmsg.getBodyLength();
            byte[] data = new byte[length];
            bmsg.readBytes(data);
            return (T)data;
        }
        if (Jms2MessageUtil.isMapMessage(message, type)) {
            MapMessage mapMessage = (MapMessage)MapMessage.class.cast(message);
            Enumeration enu = mapMessage.getMapNames();
            HashMap<String, Object> map = new HashMap<String, Object>();
            while (enu.hasMoreElements()) {
                String name = (String)enu.nextElement();
                Object value = mapMessage.getObject(name);
                map.put(name, value);
            }
            return (T)Collections.unmodifiableMap(map);
        }
        if (Message.class.isInstance(message)) {
            return null;
        }
        throw new MessageFormatException("Uable to resolve message type or body");
    }
}

