/*
 * Decompiled with CFR 0.152.
 */
package com.mockrunner.mock.jms.jms2_compat;

import com.mockrunner.mock.jms.jms2_compat.Callback;
import com.mockrunner.mock.jms.jms2_compat.Jms2Message;
import com.mockrunner.mock.jms.jms2_compat.Jms2MessageFactory;
import com.mockrunner.mock.jms.jms2_compat.Jms2Properties;
import com.mockrunner.mock.jms.jms2_compat.Jms2Util;
import com.mockrunner.mock.jms.jms2_compat.ObjectsUtil;
import jakarta.jms.BytesMessage;
import jakarta.jms.CompletionListener;
import jakarta.jms.Destination;
import jakarta.jms.JMSException;
import jakarta.jms.JMSProducer;
import jakarta.jms.MapMessage;
import jakarta.jms.Message;
import jakarta.jms.MessageProducer;
import jakarta.jms.ObjectMessage;
import jakarta.jms.Session;
import jakarta.jms.TextMessage;
import java.io.Serializable;
import java.util.Map;
import java.util.Objects;
import java.util.Set;

public final class Jms2Producer
implements JMSProducer {
    private final Session session;
    private boolean disableMessageID;
    private boolean disableMessageTimestamp;
    private Destination replyTo;
    private String jmsType;
    private Integer deliveryMode;
    private Long timeToLive;
    private Integer priourity;
    private String jmsCorrelationID;
    private Long deliveryDelay;
    private final Jms2Properties properties = new Jms2Properties();
    private CompletionListener completionListener;

    Jms2Producer(Session session) {
        this.session = Objects.requireNonNull(session);
    }

    public JMSProducer send(final Destination destination, final Message message) {
        Jms2Util.execute(new Callback<Void>(){

            @Override
            public Void execute() throws JMSException {
                MessageProducer messageProducer = Jms2Producer.this.session.createProducer(destination);
                messageProducer.setDisableMessageID(Jms2Producer.this.disableMessageID);
                messageProducer.setDisableMessageTimestamp(Jms2Producer.this.disableMessageTimestamp);
                if (ObjectsUtil.nonNull(Jms2Producer.this.deliveryMode)) {
                    messageProducer.setDeliveryMode(Jms2Producer.this.deliveryMode.intValue());
                }
                if (ObjectsUtil.nonNull(Jms2Producer.this.timeToLive)) {
                    messageProducer.setTimeToLive(Jms2Producer.this.timeToLive.longValue());
                }
                if (ObjectsUtil.nonNull(Jms2Producer.this.priourity)) {
                    messageProducer.setPriority(Jms2Producer.this.priourity.intValue());
                }
                if (ObjectsUtil.nonNull(Jms2Producer.this.replyTo)) {
                    message.setJMSReplyTo(Jms2Producer.this.replyTo);
                }
                if (ObjectsUtil.nonNull(Jms2Producer.this.jmsCorrelationID)) {
                    message.setJMSCorrelationID(Jms2Producer.this.jmsCorrelationID);
                }
                if (ObjectsUtil.nonNull(Jms2Producer.this.jmsType)) {
                    message.setJMSType(Jms2Producer.this.jmsType);
                }
                Jms2Producer.this.properties.applyToMessage(message);
                Message messageToSend = Jms2Message.class.isInstance(message) ? ((Jms2Message)Jms2Message.class.cast(message)).getDelegate() : message;
                messageProducer.send(messageToSend);
                return null;
            }
        });
        return this;
    }

    public JMSProducer send(Destination destination, String body) {
        TextMessage message = Jms2MessageFactory.createTextMessage(this.session, body);
        return this.send(destination, (Message)message);
    }

    public JMSProducer send(Destination destination, Map<String, Object> body) {
        MapMessage message = Jms2MessageFactory.createMapMessage(this.session, body);
        return this.send(destination, (Message)message);
    }

    public JMSProducer send(Destination destination, byte[] body) {
        BytesMessage message = Jms2MessageFactory.createBytesMessage(this.session, body);
        return this.send(destination, (Message)message);
    }

    public JMSProducer send(Destination destination, Serializable body) {
        ObjectMessage message = Jms2MessageFactory.createObjectMessage(this.session, body);
        return this.send(destination, (Message)message);
    }

    public JMSProducer setDisableMessageID(boolean disableMessageID) {
        this.disableMessageID = disableMessageID;
        return this;
    }

    public boolean getDisableMessageID() {
        return this.disableMessageID;
    }

    public JMSProducer setDisableMessageTimestamp(boolean disableMessageTimestamp) {
        this.disableMessageTimestamp = disableMessageTimestamp;
        return this;
    }

    public boolean getDisableMessageTimestamp() {
        return this.disableMessageTimestamp;
    }

    public JMSProducer setDeliveryMode(int deliveryMode) {
        this.deliveryMode = deliveryMode;
        return this;
    }

    public int getDeliveryMode() {
        return this.deliveryMode != null ? this.deliveryMode : 0;
    }

    public JMSProducer setPriority(int priority) {
        this.priourity = priority;
        return this;
    }

    public int getPriority() {
        return this.priourity != null ? this.priourity : 0;
    }

    public JMSProducer setTimeToLive(long timeToLive) {
        this.timeToLive = timeToLive;
        return this;
    }

    public long getTimeToLive() {
        return this.timeToLive != null ? this.timeToLive : 0L;
    }

    public JMSProducer setDeliveryDelay(long deliveryDelay) {
        this.deliveryDelay = deliveryDelay;
        return this;
    }

    public long getDeliveryDelay() {
        return this.deliveryDelay != null ? this.deliveryDelay : 0L;
    }

    public JMSProducer setAsync(CompletionListener completionListener) {
        this.completionListener = completionListener;
        return this;
    }

    public CompletionListener getAsync() {
        return this.completionListener;
    }

    public JMSProducer setProperty(String name, boolean value) {
        this.properties.setProperty(name, value);
        return this;
    }

    public JMSProducer setProperty(String name, byte value) {
        this.properties.setProperty(name, value);
        return this;
    }

    public JMSProducer setProperty(String name, short value) {
        this.properties.setProperty(name, value);
        return this;
    }

    public JMSProducer setProperty(String name, int value) {
        this.properties.setProperty(name, value);
        return this;
    }

    public JMSProducer setProperty(String name, long value) {
        this.properties.setProperty(name, value);
        return this;
    }

    public JMSProducer setProperty(String name, float value) {
        this.properties.setProperty(name, Float.valueOf(value));
        return this;
    }

    public JMSProducer setProperty(String name, double value) {
        this.properties.setProperty(name, value);
        return this;
    }

    public JMSProducer setProperty(String name, String value) {
        this.properties.setProperty(name, value);
        return this;
    }

    public JMSProducer setProperty(String name, Object value) {
        this.properties.setProperty(name, value);
        return this;
    }

    public JMSProducer clearProperties() {
        this.properties.clear();
        return this;
    }

    public boolean propertyExists(String name) {
        return this.properties.propertyExists(name);
    }

    public boolean getBooleanProperty(String name) {
        return (Boolean)this.properties.getProperty(name);
    }

    public byte getByteProperty(String name) {
        return (Byte)this.properties.getProperty(name);
    }

    public short getShortProperty(String name) {
        return (Short)this.properties.getProperty(name);
    }

    public int getIntProperty(String name) {
        return (Integer)this.properties.getProperty(name);
    }

    public long getLongProperty(String name) {
        return (Long)this.properties.getProperty(name);
    }

    public float getFloatProperty(String name) {
        return ((Float)this.properties.getProperty(name)).floatValue();
    }

    public double getDoubleProperty(String name) {
        return (Double)this.properties.getProperty(name);
    }

    public String getStringProperty(String name) {
        return (String)this.properties.getProperty(name);
    }

    public Object getObjectProperty(String name) {
        return this.properties.getProperty(name);
    }

    public Set<String> getPropertyNames() {
        return this.properties.getPropertyNames();
    }

    public JMSProducer setJMSCorrelationIDAsBytes(byte[] correlationID) {
        this.jmsCorrelationID = new String(correlationID);
        return this;
    }

    public byte[] getJMSCorrelationIDAsBytes() {
        return this.jmsCorrelationID.getBytes();
    }

    public JMSProducer setJMSCorrelationID(String jmsCorrelationID) {
        this.jmsCorrelationID = jmsCorrelationID;
        return this;
    }

    public String getJMSCorrelationID() {
        return this.jmsCorrelationID;
    }

    public JMSProducer setJMSType(String jmsType) {
        this.jmsType = jmsType;
        return this;
    }

    public String getJMSType() {
        return this.jmsType;
    }

    public JMSProducer setJMSReplyTo(Destination replyTo) {
        this.replyTo = replyTo;
        return this;
    }

    public Destination getJMSReplyTo() {
        return this.replyTo;
    }
}

