/*
 * Decompiled with CFR 0.152.
 */
package com.mockrunner.mock.jms.jms2_compat;

import com.mockrunner.mock.jms.jms2_compat.Callback;
import com.mockrunner.mock.jms.jms2_compat.Jms2Util;
import jakarta.jms.JMSException;
import jakarta.jms.Message;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Set;

public class Jms2Properties {
    private final Map<String, Object> map = new HashMap<String, Object>();

    public <T> T getProperty(String name) {
        return (T)this.map.get(name);
    }

    public <T> Jms2Properties setProperty(String name, T value) {
        this.map.put(name, value);
        return this;
    }

    public Jms2Properties clear() {
        this.map.clear();
        return this;
    }

    public boolean propertyExists(String name) {
        return this.map.containsKey(name);
    }

    public Set<String> getPropertyNames() {
        return this.map.keySet();
    }

    public void applyToMessage(final Message message) {
        Jms2Util.execute(new Callback<Void>(){

            @Override
            public Void execute() throws JMSException {
                for (String propertyName : Jms2Properties.this.getPropertyNames()) {
                    Object value = Jms2Properties.this.getProperty(propertyName);
                    Objects.requireNonNull(value);
                    if (String.class.isInstance(value)) {
                        message.setStringProperty(propertyName, (String)String.class.cast(value));
                        continue;
                    }
                    if (Integer.class.isInstance(value)) {
                        message.setIntProperty(propertyName, ((Integer)Integer.class.cast(value)).intValue());
                        continue;
                    }
                    if (Short.class.isInstance(value)) {
                        message.setShortProperty(propertyName, ((Short)Short.class.cast(value)).shortValue());
                        continue;
                    }
                    if (Double.class.isInstance(value)) {
                        message.setDoubleProperty(propertyName, ((Double)Double.class.cast(value)).doubleValue());
                        continue;
                    }
                    if (Float.class.isInstance(value)) {
                        message.setFloatProperty(propertyName, ((Float)Float.class.cast(value)).floatValue());
                        continue;
                    }
                    if (Boolean.class.isInstance(value)) {
                        message.setBooleanProperty(propertyName, ((Boolean)Boolean.class.cast(value)).booleanValue());
                        continue;
                    }
                    if (Byte.class.isInstance(value)) {
                        message.setByteProperty(propertyName, ((Byte)Byte.class.cast(value)).byteValue());
                        continue;
                    }
                    message.setObjectProperty(propertyName, value);
                }
                return null;
            }
        });
    }
}

