/*
 * Decompiled with CFR 0.152.
 */
package com.mockrunner.mock.jms.jms2_compat;

import com.mockrunner.mock.jms.jms2_compat.Callback;
import com.mockrunner.mock.jms.jms2_compat.Jms2Consumer;
import com.mockrunner.mock.jms.jms2_compat.Jms2Context;
import com.mockrunner.mock.jms.jms2_compat.Jms2MessageListener;
import com.mockrunner.mock.jms.jms2_compat.TopicSubscriberAdaptor;
import jakarta.jms.Connection;
import jakarta.jms.ConnectionMetaData;
import jakarta.jms.Destination;
import jakarta.jms.ExceptionListener;
import jakarta.jms.JMSException;
import jakarta.jms.JMSRuntimeException;
import jakarta.jms.Message;
import jakarta.jms.MessageConsumer;
import jakarta.jms.MessageFormatException;
import jakarta.jms.MessageFormatRuntimeException;
import jakarta.jms.MessageListener;
import jakarta.jms.Queue;
import jakarta.jms.QueueBrowser;
import jakarta.jms.Session;
import jakarta.jms.TemporaryQueue;
import jakarta.jms.TemporaryTopic;
import jakarta.jms.Topic;
import jakarta.jms.TopicSubscriber;

public final class Jms2Util {
    static TemporaryQueue createTemporaryQueue(final Session session) {
        return Jms2Util.execute(new Callback<TemporaryQueue>(){

            @Override
            public TemporaryQueue execute() throws JMSException {
                return session.createTemporaryQueue();
            }
        });
    }

    static TemporaryTopic createTemporaryTopic(final Session session) {
        return Jms2Util.execute(new Callback<TemporaryTopic>(){

            @Override
            public TemporaryTopic execute() throws JMSException {
                return session.createTemporaryTopic();
            }
        });
    }

    static QueueBrowser createBrowser(final Session session, final Queue queue) {
        return Jms2Util.execute(new Callback<QueueBrowser>(){

            @Override
            public QueueBrowser execute() throws JMSException {
                return session.createBrowser(queue);
            }
        });
    }

    static QueueBrowser createBrowser(final Session session, final Queue queue, final String selector) {
        return Jms2Util.execute(new Callback<QueueBrowser>(){

            @Override
            public QueueBrowser execute() throws JMSException {
                return session.createBrowser(queue, selector);
            }
        });
    }

    static Jms2Consumer createDurableConsumer(Jms2Context context, Topic topic, String name) {
        return new Jms2Consumer(context, Jms2Util.createDurableMessageConsumer(context.getSession(), topic, name));
    }

    static Jms2Consumer createDurableConsumer(Jms2Context context, Topic topic, String name, String selector, boolean noLocal) {
        return new Jms2Consumer(context, Jms2Util.createDurableMessageConsumer(context.getSession(), topic, name, selector, noLocal));
    }

    static Jms2Consumer createSharedDurableConsumer(Jms2Context context, Topic topic, String name, String selector) {
        return new Jms2Consumer(context, Jms2Util.createDurableMessageConsumer(context.getSession(), topic, name, selector, false));
    }

    static Jms2Consumer createSharedConsumer(Jms2Context context, Topic topic, String name) {
        return context.addConsumer(Jms2Util.createSharedConsumer(context, topic, name, null));
    }

    static Jms2Consumer createSharedConsumer(Jms2Context context, Topic topic, String name, String selector) {
        return context.addConsumer(Jms2Util.createDurableConsumer(context, topic, name, selector, false));
    }

    static JMSRuntimeException uncheck(MessageFormatException ex) {
        return new MessageFormatRuntimeException(ex.getMessage(), ex.getErrorCode(), (Throwable)ex);
    }

    static JMSRuntimeException uncheck(JMSException ex) {
        return new JMSRuntimeException(ex.getMessage(), ex.getErrorCode(), (Throwable)ex);
    }

    static boolean isClientAcknowledge(Session session) {
        return Jms2Util.getSessionMode(session) == 2;
    }

    private Jms2Util() {
    }

    static void commit(final Session session) {
        Jms2Util.execute(new Callback<Void>(){

            @Override
            public Void execute() throws JMSException {
                session.commit();
                return null;
            }
        });
    }

    public static <T> T execute(Callback<T> callback) {
        try {
            return callback.execute();
        }
        catch (JMSException ex) {
            throw Jms2Util.uncheck(ex);
        }
    }

    static void rollback(final Session session) {
        Jms2Util.execute(new Callback<Void>(){

            @Override
            public Void execute() throws JMSException {
                session.rollback();
                return null;
            }
        });
    }

    static void recover(final Session session) {
        Jms2Util.execute(new Callback<Void>(){

            @Override
            public Void execute() throws JMSException {
                session.recover();
                return null;
            }
        });
    }

    static int getSessionMode(final Session session) {
        return Jms2Util.execute(new Callback<Integer>(){

            @Override
            public Integer execute() throws JMSException {
                return session.getAcknowledgeMode();
            }
        });
    }

    static boolean getTransacted(final Session session) {
        return Jms2Util.execute(new Callback<Boolean>(){

            @Override
            public Boolean execute() throws JMSException {
                return session.getTransacted();
            }
        });
    }

    static void unsubscribe(final Session session, final String name) {
        Jms2Util.execute(new Callback<Void>(){

            @Override
            public Void execute() throws JMSException {
                session.unsubscribe(name);
                return null;
            }
        });
    }

    static String getClientID(final Connection connection) {
        return Jms2Util.execute(new Callback<String>(){

            @Override
            public String execute() throws JMSException {
                return connection.getClientID();
            }
        });
    }

    static void setClientID(final Connection connection, final String clientID) {
        Jms2Util.execute(new Callback<Void>(){

            @Override
            public Void execute() throws JMSException {
                connection.setClientID(clientID);
                return null;
            }
        });
    }

    static ConnectionMetaData getMetaData(final Connection connection) {
        return Jms2Util.execute(new Callback<ConnectionMetaData>(){

            @Override
            public ConnectionMetaData execute() throws JMSException {
                return connection.getMetaData();
            }
        });
    }

    static ExceptionListener getExceptionListener(final Connection connection) {
        return Jms2Util.execute(new Callback<ExceptionListener>(){

            @Override
            public ExceptionListener execute() throws JMSException {
                return connection.getExceptionListener();
            }
        });
    }

    static void setExceptionListener(final Connection connection, final ExceptionListener listener) {
        Jms2Util.execute(new Callback<Void>(){

            @Override
            public Void execute() throws JMSException {
                connection.setExceptionListener(listener);
                return null;
            }
        });
    }

    static void start(final Connection connection) {
        Jms2Util.execute(new Callback<Void>(){

            @Override
            public Void execute() throws JMSException {
                connection.start();
                return null;
            }
        });
    }

    static void stop(final Connection connection) {
        Jms2Util.execute(new Callback<Void>(){

            @Override
            public Void execute() throws JMSException {
                connection.stop();
                return null;
            }
        });
    }

    static void close(Connection connection, Session session) {
        try {
            Jms2Util.close(session);
        }
        finally {
            Jms2Util.close(connection);
        }
    }

    static String getMessageSelector(final MessageConsumer consumer) {
        return Jms2Util.execute(new Callback<String>(){

            @Override
            public String execute() throws JMSException {
                return consumer.getMessageSelector();
            }
        });
    }

    static Message receive(final MessageConsumer consumer) {
        return Jms2Util.execute(new Callback<Message>(){

            @Override
            public Message execute() throws JMSException {
                Message m = consumer.receive();
                return m;
            }
        });
    }

    static Message receive(final MessageConsumer consumer, final long timeout) {
        return Jms2Util.execute(new Callback<Message>(){

            @Override
            public Message execute() throws JMSException {
                Message m = consumer.receive(timeout);
                if (m == null) {
                    return null;
                }
                return m;
            }
        });
    }

    static Message receiveNoWait(final MessageConsumer consumer) {
        return Jms2Util.execute(new Callback<Message>(){

            @Override
            public Message execute() throws JMSException {
                Message m = consumer.receiveNoWait();
                if (m == null) {
                    return null;
                }
                return m;
            }
        });
    }

    static void close(final MessageConsumer consumer) {
        Jms2Util.execute(new Callback<Void>(){

            @Override
            public Void execute() throws JMSException {
                consumer.close();
                return null;
            }
        });
    }

    static MessageListener getMessageListener(final MessageConsumer consumer) {
        return Jms2Util.execute(new Callback<MessageListener>(){

            @Override
            public MessageListener execute() throws JMSException {
                return consumer.getMessageListener();
            }
        });
    }

    static void setMessageListener(final MessageConsumer consumer, final MessageListener listener) {
        Jms2Util.execute(new Callback<Void>(){

            @Override
            public Void execute() throws JMSException {
                consumer.setMessageListener((MessageListener)new Jms2MessageListener(listener));
                return null;
            }
        });
    }

    static MessageConsumer createDurableMessageConsumer(final Session session, final Topic topic, final String name, final String selector, final boolean noLocal) {
        return Jms2Util.execute(new Callback<TopicSubscriberAdaptor>(){

            @Override
            public TopicSubscriberAdaptor execute() throws JMSException {
                TopicSubscriber subscriber = selector == null ? session.createDurableSubscriber(topic, name) : session.createDurableSubscriber(topic, name, selector, noLocal);
                return new TopicSubscriberAdaptor(subscriber);
            }
        });
    }

    static MessageConsumer createDurableMessageConsumer(final Session session, final Topic topic, final String name) {
        return Jms2Util.execute(new Callback<TopicSubscriberAdaptor>(){

            @Override
            public TopicSubscriberAdaptor execute() throws JMSException {
                TopicSubscriber topicSubscriber = session.createDurableSubscriber(topic, name);
                return new TopicSubscriberAdaptor(topicSubscriber);
            }
        });
    }

    static MessageConsumer createSharedMessageConsumer(Session session, Topic topic, String sharedSubscriptionName, String selector) {
        return Jms2Util.createDurableMessageConsumer(session, topic, sharedSubscriptionName, selector, false);
    }

    static MessageConsumer createMessageConsumer(final Session session, final Destination destination, final String selector, Boolean noLocal) {
        return Jms2Util.execute(new Callback<MessageConsumer>(){

            @Override
            public MessageConsumer execute() throws JMSException {
                if (selector == null) {
                    return session.createConsumer(destination);
                }
                return session.createConsumer(destination, selector);
            }
        });
    }

    static Jms2Consumer createConsumer(Jms2Context context, Destination destination) {
        return Jms2Util.createConsumer(context, destination, null, null);
    }

    static Jms2Consumer createConsumer(Jms2Context context, Destination destination, String selector) {
        return Jms2Util.createConsumer(context, destination, selector, null);
    }

    static Jms2Consumer createConsumer(Jms2Context context, Destination destination, String selector, Boolean arg) {
        MessageConsumer messageConsumer = Jms2Util.createMessageConsumer(context.getSession(), destination, selector, null);
        Jms2Consumer consumer = new Jms2Consumer(context, messageConsumer);
        return context.addConsumer(consumer);
    }

    static Queue createQueue(final Session session, final String queueName) {
        return Jms2Util.execute(new Callback<Queue>(){

            @Override
            public Queue execute() throws JMSException {
                return session.createQueue(queueName);
            }
        });
    }

    static Topic createTopic(final Session session, final String topicName) {
        return Jms2Util.execute(new Callback<Topic>(){

            @Override
            public Topic execute() throws JMSException {
                return session.createTopic(topicName);
            }
        });
    }

    static void close(final Session session) {
        Jms2Util.execute(new Callback<Void>(){

            @Override
            public Void execute() throws JMSException {
                session.close();
                return null;
            }
        });
    }

    static void close(final Connection connection) {
        Jms2Util.execute(new Callback<Void>(){

            @Override
            public Void execute() throws JMSException {
                connection.close();
                return null;
            }
        });
    }

    static MessageListener getMessageListener(final Session session) {
        return Jms2Util.execute(new Callback<MessageListener>(){

            @Override
            public MessageListener execute() throws JMSException {
                return session.getMessageListener();
            }
        });
    }

    static void setMessageListener(final Session session, final MessageListener listener) {
        Jms2Util.execute(new Callback<Void>(){

            @Override
            public Void execute() throws JMSException {
                session.setMessageListener((MessageListener)new Jms2MessageListener(listener));
                return null;
            }
        });
    }
}

