/*
 * Decompiled with CFR 0.152.
 */
package net.oneandone.mork.classfile;

import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;

public enum Access {
    PUBLIC(1),
    PRIVATE(2),
    PROTECTED(4),
    STATIC(8),
    FINAL(16),
    SUPER(32, true),
    SYNCHRONIZED(32),
    VOLATILE(64),
    TRANSIENT(128),
    NATIVE(256),
    INTERFACE(512, true),
    ABSTRACT(1024);

    private final int code;
    private final boolean forClass;

    private Access(int code) {
        this(code, false);
    }

    private Access(int code, boolean forClass) {
        this.code = code;
        this.forClass = forClass;
    }

    public static Set<Access> fromFlags(char flags, boolean forClass) {
        HashSet<Access> result = new HashSet<Access>();
        for (Access a : Access.values()) {
            if (a.forClass && !forClass || (flags & a.code) != a.code) continue;
            result.add(a);
            flags = (char)(flags & ~a.code);
        }
        return result;
    }

    public static Set<Access> fromArray(Access ... flags) {
        return new HashSet<Access>(Arrays.asList(flags));
    }

    public static char toFlags(Set<Access> lst) {
        char flags = '\u0000';
        for (Access a : lst) {
            flags = (char)(flags | a.code);
        }
        return flags;
    }

    public static String toPrefix(Set<Access> accessFlags) {
        StringBuilder builder = new StringBuilder();
        boolean first = true;
        for (Access a : accessFlags) {
            if (a == SUPER) continue;
            if (first) {
                first = false;
            } else {
                builder.append(' ');
            }
            builder.append(a.toString().toLowerCase());
        }
        if (!first) {
            builder.append(' ');
        }
        return builder.toString();
    }
}

