/*
 * Decompiled with CFR 0.152.
 */
package net.oneandone.mork.classfile;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import net.oneandone.mork.classfile.Access;
import net.oneandone.mork.classfile.ClassRef;
import net.oneandone.mork.classfile.Code;
import net.oneandone.mork.classfile.Definition;
import net.oneandone.mork.classfile.FieldDef;
import net.oneandone.mork.classfile.Input;
import net.oneandone.mork.classfile.MethodDef;
import net.oneandone.mork.classfile.Output;
import net.oneandone.mork.classfile.attribute.Attribute;

public class ClassDef
extends Definition {
    public Set<Access> accessFlags;
    public ClassRef thisClass;
    public ClassRef superClass;
    public final List<ClassRef> interfaces;
    public final List<FieldDef> fields;
    public final List<MethodDef> methods;
    public final List<Attribute> attributes;

    public ClassDef(ClassRef thisClass, ClassRef superClass) {
        this.accessFlags = new HashSet<Access>();
        this.accessFlags.add(Access.PUBLIC);
        this.accessFlags.add(Access.SUPER);
        this.thisClass = thisClass;
        this.superClass = superClass;
        this.interfaces = new ArrayList<ClassRef>();
        this.fields = new ArrayList<FieldDef>();
        this.methods = new ArrayList<MethodDef>();
        this.attributes = new ArrayList<Attribute>();
    }

    public ClassDef(Input src) throws IOException {
        int i;
        this.interfaces = new ArrayList<ClassRef>();
        this.fields = new ArrayList<FieldDef>();
        this.methods = new ArrayList<MethodDef>();
        this.attributes = new ArrayList<Attribute>();
        this.accessFlags = Access.fromFlags(src.readU2(), true);
        this.thisClass = src.readClassRef();
        try {
            this.superClass = src.readClassRef();
        }
        catch (NullPointerException e) {
            if (!this.thisClass.isJavaLangObject()) {
                throw new RuntimeException("missing base class for " + this.thisClass);
            }
            this.superClass = null;
        }
        int max = src.readU2();
        for (i = 0; i < max; ++i) {
            this.interfaces.add(src.readClassRef());
        }
        max = src.readU2();
        for (i = 0; i < max; ++i) {
            this.fields.add(new FieldDef(src));
        }
        max = src.readU2();
        for (i = 0; i < max; ++i) {
            this.methods.add(new MethodDef(src));
        }
        max = src.readU2();
        for (i = 0; i < max; ++i) {
            this.attributes.add(Attribute.create(src));
        }
    }

    public String getName() {
        return this.thisClass.name;
    }

    public MethodDef lookupMethod(MethodDef lm) {
        return this.lookupMethod(lm.accessFlags, lm.name, lm.argumentTypes, lm.returnType, lm.getExceptions());
    }

    public MethodDef lookupMethod(Set<Access> accessFlags, String name, ClassRef[] argumentTypes, ClassRef returnType, List<ClassRef> exceptions) {
        for (MethodDef m : this.methods) {
            if (!m.accessFlags.equals(accessFlags) || !m.name.equals(name) || !Arrays.equals(m.argumentTypes, argumentTypes) || !m.returnType.equals(returnType) || !m.getExceptions().equals(exceptions)) continue;
            return m;
        }
        return null;
    }

    public MethodDef lookupMethod(String name, ClassRef ... argumentTypes) {
        for (MethodDef m : this.methods) {
            if (!m.name.equals(name) || !Arrays.equals(m.argumentTypes, argumentTypes)) continue;
            return m;
        }
        return null;
    }

    public FieldDef lookupField(FieldDef field) {
        return this.lookupField(field.accessFlags, field.name, field.type);
    }

    public FieldDef lookupField(Set<Access> accessFlags, String name, ClassRef type) {
        for (FieldDef f : this.fields) {
            if (!f.accessFlags.equals(accessFlags) || !f.name.equals(name) || !f.type.equals(type)) continue;
            return f;
        }
        return null;
    }

    public FieldDef lookupField(String name) {
        for (FieldDef f : this.fields) {
            if (!f.name.equals(name)) continue;
            return f;
        }
        return null;
    }

    public void write(Output dest) throws IOException {
        int i;
        dest.writeU2(Access.toFlags(this.accessFlags));
        dest.writeClassRef(this.thisClass);
        if (this.superClass != null) {
            dest.writeClassRef(this.superClass);
        } else {
            dest.writeU2(0);
        }
        int max = this.interfaces.size();
        dest.writeU2(max);
        for (i = 0; i < max; ++i) {
            dest.writeClassRef(this.interfaces.get(i));
        }
        max = this.fields.size();
        dest.writeU2(max);
        for (i = 0; i < max; ++i) {
            this.fields.get(i).write(dest);
        }
        max = this.methods.size();
        dest.writeU2(max);
        for (i = 0; i < max; ++i) {
            this.methods.get(i).write(dest);
        }
        max = this.attributes.size();
        dest.writeU2(max);
        for (i = 0; i < max; ++i) {
            this.attributes.get(i).write(dest);
        }
    }

    public ClassRef reference() {
        return this.thisClass;
    }

    public FieldDef addField(Set<Access> access, ClassRef type, String name) {
        FieldDef f = new FieldDef(access, name, type);
        this.fields.add(f);
        return f;
    }

    public MethodDef addMethod(Set<Access> accessFlags, ClassRef result, String name, ClassRef[] args, Code code) {
        MethodDef m = new MethodDef();
        m.name = name;
        m.accessFlags = accessFlags;
        m.attributes.add(code);
        m.argumentTypes = args;
        m.returnType = result;
        this.methods.add(m);
        return m;
    }

    public MethodDef addConstructor(Set<Access> accessFlags, ClassRef[] args, Code code) {
        MethodDef m = new MethodDef();
        m.name = "<init>";
        m.accessFlags = accessFlags;
        m.attributes.add(code);
        m.argumentTypes = args;
        m.returnType = ClassRef.VOID;
        this.methods.add(m);
        return m;
    }

    public String toString() {
        int i;
        StringBuilder result = new StringBuilder();
        result.append("thisClass: " + this.thisClass + "\n");
        result.append("superClass: " + this.superClass + "\n");
        int max = this.interfaces.size();
        for (i = 0; i < max; ++i) {
            result.append("implements: " + this.interfaces.get(i) + "\n");
        }
        max = this.fields.size();
        for (i = 0; i < max; ++i) {
            result.append("field: " + this.fields.get(i) + "\n");
        }
        max = this.methods.size();
        for (i = 0; i < max; ++i) {
            result.append("method: " + this.methods.get(i) + "\n");
        }
        return result.toString();
    }

    public String toSignatureString() {
        StringBuilder result = new StringBuilder();
        result.append(Access.toPrefix(this.accessFlags));
        result.append(this.getName());
        int max = this.interfaces.size();
        if (!this.superClass.isJavaLangObject()) {
            result.append(" extends ");
            result.append(this.superClass.toString());
        }
        if (max > 0) {
            result.append(" implements");
            for (int i = 0; i < max; ++i) {
                result.append(' ');
                result.append(this.interfaces.get(i));
            }
        }
        return result.toString();
    }
}

