/*
 * Decompiled with CFR 0.152.
 */
package net.oneandone.mork.classfile;

import java.io.File;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import net.oneandone.mork.classfile.Bytecodes;
import net.oneandone.mork.classfile.ClassDef;
import net.oneandone.mork.classfile.Code;
import net.oneandone.mork.classfile.Constants;
import net.oneandone.mork.classfile.Reference;
import net.oneandone.mork.classfile.Repository;
import net.oneandone.mork.classfile.ResolveException;
import net.oneandone.mork.classfile.Type;
import net.oneandone.sushi.util.Arrays;

public class ClassRef
extends Reference
implements Bytecodes,
Constants {
    public static final ClassRef VOID = new ClassRef(Void.TYPE);
    public static final ClassRef BOOLEAN = new ClassRef(Boolean.TYPE);
    public static final ClassRef INT = new ClassRef(Integer.TYPE);
    public static final ClassRef CHAR = new ClassRef(Character.TYPE);
    public static final ClassRef OBJECT = new ClassRef("java.lang.Object");
    public static final ClassRef STRING = new ClassRef("java.lang.String");
    public static final ClassRef[] NONE = new ClassRef[0];
    public final String name;
    public final int dimensions;
    public final Type componentType;

    public ClassRef(Class<?> c) {
        int d = 0;
        while (c.isArray()) {
            c = c.getComponentType();
            ++d;
        }
        this.name = c.getName();
        this.dimensions = d;
        this.componentType = ClassRef.findType(this.name);
    }

    public ClassRef(String name) {
        this(name, 0, ClassRef.findType(name));
    }

    public ClassRef(String name, int dimensions) {
        this(name, dimensions, ClassRef.findType(name));
    }

    private ClassRef(String name, int dimensions, Type componentType) {
        if (name.startsWith("[")) {
            throw new IllegalArgumentException(name);
        }
        this.name = name;
        this.dimensions = dimensions;
        this.componentType = componentType;
    }

    @Override
    public ClassRef getOwner() {
        return this;
    }

    @Override
    public ClassDef lookup(Repository repository) throws ResolveException {
        try {
            return repository.lookup(this.dimensions == 0 ? this.name : "java.lang.Object");
        }
        catch (IOException e) {
            throw new ResolveException(this, e);
        }
    }

    public boolean isArray() {
        return this.dimensions != 0;
    }

    public boolean isPrimitive() {
        return this.dimensions == 0 && this.componentType.id != 2;
    }

    public boolean isJavaLangObject() {
        return this.name.equals("java.lang.Object");
    }

    public int operandSize() {
        return this.getTypeCode().size;
    }

    private static Type findType(String name) {
        for (int i = 0; i < Type.PRIMITIVES.length; ++i) {
            Type cmp = Type.PRIMITIVES[i];
            if (!name.equals(cmp.name)) continue;
            return cmp;
        }
        return Type.REFERENCE;
    }

    public static Type findComponent(Class<?> type) {
        for (int i = 0; i < Type.PRIMITIVES.length; ++i) {
            Type cmp = Type.PRIMITIVES[i];
            if (type != cmp.type) continue;
            return cmp;
        }
        return Type.REFERENCE;
    }

    public boolean equals(Object obj) {
        if (obj instanceof ClassRef) {
            ClassRef r = (ClassRef)obj;
            return this.dimensions == r.dimensions && this.componentType == r.componentType && this.name.equals(r.name);
        }
        return false;
    }

    public int hashCode() {
        return this.name.hashCode();
    }

    public Class<?> lookup() {
        Class result = ClassRef.classFind(this.name);
        for (int count = this.dimensions; count > 0; --count) {
            result = Arrays.getArrayClass(result);
        }
        return result;
    }

    public String toString() {
        String result = this.name;
        for (int i = 0; i < this.dimensions; ++i) {
            result = result + "[]";
        }
        return result;
    }

    public String toFieldDescriptor() {
        StringBuilder result = new StringBuilder();
        for (int i = 0; i < this.dimensions; ++i) {
            result.append('[');
        }
        result.append(this.componentType.descriptor);
        if (this.componentType.id == 2) {
            result.append(this.name.replace('.', '/'));
            result.append(';');
        }
        return result.toString();
    }

    public static ClassRef forFieldDescriptor(String descriptor) {
        return (ClassRef)ClassRef.forFieldDescriptor(descriptor, 0, descriptor.length())[0];
    }

    public static Object[] forFieldDescriptor(String descriptor, int ofs, int length) {
        int nextOfs;
        String name;
        Type typeCode;
        int dimensions = 0;
        while (ofs < length && descriptor.charAt(ofs) == '[') {
            ++dimensions;
            ++ofs;
        }
        if (ofs >= length) {
            throw new RuntimeException("illegal descriptor: " + descriptor);
        }
        char c = descriptor.charAt(ofs);
        if (c == Type.REFERENCE.descriptor) {
            typeCode = Type.REFERENCE;
            int i = descriptor.indexOf(59, ofs);
            if (i == -1) {
                throw new RuntimeException(descriptor + ofs);
            }
            name = descriptor.substring(ofs + 1, i).replace('/', '.');
            nextOfs = i + 1;
        } else {
            typeCode = null;
            for (int i = 0; i < Type.PRIMITIVES.length; ++i) {
                typeCode = Type.PRIMITIVES[i];
                if (typeCode.descriptor == c) break;
            }
            if (typeCode == null) {
                throw new RuntimeException("illegal descriptor char " + c + ", ofs " + ofs + " in: " + descriptor);
            }
            name = typeCode.name;
            nextOfs = ofs + 1;
        }
        return new Object[]{new ClassRef(name, dimensions, typeCode), nextOfs};
    }

    public String toDescriptor() {
        if (this.isArray()) {
            StringBuilder result = new StringBuilder();
            for (int i = 0; i < this.dimensions; ++i) {
                result.append('[');
            }
            result.append(this.componentType.descriptor);
            if (this.componentType.id == 2) {
                result.append(this.name.replace('.', '/'));
                result.append(';');
            }
            return result.toString();
        }
        if (this.componentType.id != 2) {
            throw new RuntimeException("not a reference type: " + this);
        }
        return this.name.replace('.', '/');
    }

    public static String fileToResName(String fileName) {
        return fileName.replace(File.pathSeparatorChar, '/');
    }

    public static String resToFileName(String resName) {
        return resName.replace('/', File.pathSeparatorChar);
    }

    public static String resToClassName(String resName) {
        return resName.substring(0, resName.length() - 6).replace('/', '.');
    }

    public static String classToResName(String className) {
        return className.replace('.', '/') + ".class";
    }

    public static String fileToClassName(String fileName) {
        return ClassRef.resToClassName(ClassRef.fileToResName(fileName));
    }

    public static String classToFileName(String className) {
        return ClassRef.resToFileName(ClassRef.classToResName(className));
    }

    public static Class<?> wrappedType(Class<?> c) {
        if (c.isPrimitive()) {
            for (int i = 0; i < Type.PRIMITIVES.length; ++i) {
                if (Type.PRIMITIVES[i].type != c) continue;
                return Type.PRIMITIVES[i].wrapper;
            }
            throw new RuntimeException();
        }
        return c;
    }

    public static Class<?> unwrappedType(Class<?> c) {
        for (int i = 0; i < Type.PRIMITIVES.length; ++i) {
            if (Type.PRIMITIVES[i].wrapper != c) continue;
            return Type.PRIMITIVES[i].type;
        }
        return c;
    }

    public static Class<?> classFind(String name) {
        try {
            return Class.forName(name);
        }
        catch (ClassNotFoundException e) {
            return ClassRef.findType((String)name).type;
        }
    }

    public static Class<?> commonBase(Class<?> a, Class<?> b) {
        Class<?> ifc;
        if (b == null) {
            throw new IllegalArgumentException();
        }
        if (a == null) {
            return b;
        }
        Class<?> result = ClassRef.commonSuperClass(a, b);
        if (Object.class.equals(result) && (ifc = ClassRef.commonInterfaces(a, b)) != null) {
            result = ifc;
        }
        return result;
    }

    private static Class<?> commonInterfaces(Class<?> a, Class<?> b) {
        for (Class<?> left : a.getInterfaces()) {
            for (Class<?> right : b.getInterfaces()) {
                if (!left.equals(right)) continue;
                return left;
            }
        }
        return null;
    }

    private static Class<?> commonSuperClass(Class<?> a, Class<?> b) {
        if (a.isAssignableFrom(b)) {
            return a;
        }
        if (b.isAssignableFrom(a)) {
            return b;
        }
        Class<?> c = b.getSuperclass();
        if (c == null) {
            return null;
        }
        return ClassRef.commonSuperClass(a, c);
    }

    public static void write(ObjectOutput out, Class<?> cl) throws IOException {
        if (cl == null) {
            out.writeByte(-1);
        } else {
            int dim = 0;
            while (cl.isArray()) {
                ++dim;
                cl = cl.getComponentType();
            }
            if (dim > 127) {
                throw new RuntimeException("to many dimensions");
            }
            out.writeByte((byte)dim);
            out.writeUTF(cl.getName());
        }
    }

    public static Class<?> read(ObjectInput in) throws IOException {
        byte dim = in.readByte();
        if (dim == -1) {
            return null;
        }
        String name = in.readUTF();
        Class cl = ClassRef.classFind(name);
        if (cl == null) {
            throw new RuntimeException("can't load class " + name);
        }
        while (true) {
            byte by = dim;
            dim = (byte)(dim - 1);
            if (by <= 0) break;
            cl = Arrays.getArrayClass(cl);
        }
        return cl;
    }

    public static void writeClasses(ObjectOutput out, Class<?>[] types) throws IOException {
        if (types.length > 127) {
            throw new RuntimeException("to many dimensions");
        }
        out.writeByte((byte)types.length);
        for (int i = 0; i < types.length; ++i) {
            ClassRef.write(out, types[i]);
        }
    }

    public static Class<?>[] readClasses(ObjectInput in) throws IOException, ClassNotFoundException {
        int len = in.readByte();
        Class[] result = new Class[len];
        for (int i = 0; i < len; ++i) {
            result[i] = ClassRef.read(in);
        }
        return result;
    }

    private Type getTypeCode() {
        if (this.isArray()) {
            return Type.REFERENCE;
        }
        return this.componentType;
    }

    public Object getDefault() {
        return this.getTypeCode().zero;
    }

    public Object getLdcDefault() {
        return this.getTypeCode().zeroLdc;
    }

    public void emitDefault(Code dest) {
        dest.emitGeneric(18, new Object[]{this.getLdcDefault()});
    }

    public void emitLoad(Code dest, int var) {
        int c = this.getTypeCode().load;
        if (c != -1) {
            dest.emit(c, var);
        }
    }

    public void emitStore(Code dest, int var) {
        int c = this.getTypeCode().store;
        if (c != -1) {
            dest.emit(c, var);
        }
    }

    public void emitArrayNew(Code dest) {
        Type typeCode = this.getTypeCode();
        if (typeCode.id == 2) {
            dest.emit(189, this);
        } else {
            dest.emit(188, typeCode.id);
        }
    }

    public void emitArrayLoad(Code dest) {
        dest.emit(this.getTypeCode().arrayLoad);
    }

    public void emitArrayStore(Code dest) {
        dest.emit(this.getTypeCode().arrayStore);
    }

    public boolean isArrayDefaultElement(Object obj) {
        Type typeCode = this.getTypeCode();
        switch (typeCode.id) {
            case 4: {
                return (Boolean)obj == false;
            }
            case 8: 
            case 9: 
            case 10: 
            case 11: {
                return ((Number)obj).longValue() == 0L;
            }
            case 5: {
                return ((Character)obj).charValue() == '\u0000';
            }
            case 6: 
            case 7: {
                return ((Number)obj).doubleValue() == 0.0;
            }
            case 2: {
                return obj == null;
            }
        }
        throw new RuntimeException("not supported: " + typeCode.id);
    }
}

