/*
 * Decompiled with CFR 0.152.
 */
package net.oneandone.mork.classfile;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.logging.Logger;
import net.oneandone.mork.classfile.ClassRef;
import net.oneandone.mork.classfile.Constants;
import net.oneandone.mork.classfile.ExceptionInfo;
import net.oneandone.mork.classfile.FieldRef;
import net.oneandone.mork.classfile.Input;
import net.oneandone.mork.classfile.Instruction;
import net.oneandone.mork.classfile.InstructionType;
import net.oneandone.mork.classfile.Jsr;
import net.oneandone.mork.classfile.MethodRef;
import net.oneandone.mork.classfile.Output;
import net.oneandone.mork.classfile.Reference;
import net.oneandone.mork.classfile.Set;
import net.oneandone.mork.classfile.attribute.Attribute;
import net.oneandone.sushi.util.IntArrayList;
import net.oneandone.sushi.util.IntBitSet;
import net.oneandone.sushi.util.IntCollection;

public class Code
extends Attribute
implements Constants {
    public static final Logger LOGGER = Logger.getLogger(Code.class.getName());
    public int locals = 0;
    public List<Instruction> instructions = new ArrayList<Instruction>();
    public List<ExceptionInfo> exceptions = new ArrayList<ExceptionInfo>();
    public List<Attribute> attributes = new ArrayList<Attribute>();
    private int codeSize;
    private IntArrayList labels = new IntArrayList();

    public Code() {
        super("Code");
        this.labels.add(0);
    }

    public Code(Input src) throws IOException {
        this();
        int i;
        Instruction instr;
        src.readU4();
        char loadedStack = src.readU2();
        this.locals = src.readU2();
        int max = src.readU4();
        src.openCode(this);
        while (src.getOfs() < max) {
            instr = Instruction.read(src);
            this.instructions.add(instr);
        }
        this.codeSize = src.getOfs();
        max = this.instructions.size();
        for (i = 0; i < max; ++i) {
            instr = this.instructions.get(i);
            instr.ofsToIdx(this);
        }
        max = src.readU2();
        for (i = 0; i < max; ++i) {
            this.exceptions.add(new ExceptionInfo(src));
        }
        max = src.readU2();
        for (i = 0; i < max; ++i) {
            this.attributes.add(Attribute.create(src));
        }
        src.closeCode();
        int computedStack = this.calcStackSize();
        if (loadedStack < computedStack) {
            LOGGER.warning("loaded stack size differs from computed: loaded: " + loadedStack + " < computed: " + computedStack);
        }
    }

    public void references(Collection<Reference> result) {
        for (Instruction i : this.instructions) {
            for (Object arg : i.arguments) {
                if (!(arg instanceof Reference)) continue;
                result.add((Reference)arg);
            }
        }
    }

    public int getSize() {
        return this.instructions.size();
    }

    @Override
    public void write(Output dest) throws IOException {
        int i;
        this.layout(dest);
        if (this.codeSize > 65535) {
            throw new IllegalStateException("code segment exceeds 64k");
        }
        dest.writeUtf8(this.name);
        int start = dest.writeSpace(4);
        dest.writeU2(this.calcStackSize());
        dest.writeU2(this.locals);
        dest.writeU4(this.codeSize);
        dest.openCode(this);
        int max = this.instructions.size();
        for (i = 0; i < max; ++i) {
            Instruction instr = this.instructions.get(i);
            instr.write(dest);
        }
        max = this.exceptions.size();
        dest.writeU2(max);
        for (i = 0; i < max; ++i) {
            ExceptionInfo info = this.exceptions.get(i);
            info.write(dest);
        }
        max = this.attributes.size();
        dest.writeU2(max);
        for (i = 0; i < max; ++i) {
            Attribute attr = this.attributes.get(i);
            attr.write(dest);
        }
        dest.closeCode();
        dest.writeFixup(start, dest.getGlobalOfs() - (start + 4));
    }

    private void layout(Output dest) {
        boolean changes;
        int len;
        Instruction instr;
        int i;
        int instrSize = this.instructions.size();
        IntArrayList vars = new IntArrayList();
        IntArrayList lens = new IntArrayList();
        int ofs = 0;
        for (i = 0; i < instrSize; ++i) {
            instr = this.instructions.get(i);
            instr.ofs = ofs;
            len = instr.getMaxLength(dest);
            ofs += len;
            if (!instr.type.isVariable()) continue;
            vars.add(i);
            lens.add(len);
        }
        this.codeSize = ofs;
        int varSize = vars.size();
        do {
            changes = false;
            int shrink = 0;
            for (i = 0; i < varSize; ++i) {
                int k;
                int j = vars.get(i);
                instr = this.instructions.get(j);
                len = instr.getVariableLength(this);
                if (len < lens.get(i)) {
                    changes = true;
                    shrink += lens.get(i) - len;
                    lens.set(i, len);
                }
                if (shrink <= 0) continue;
                int n = k = i + 1 == varSize ? instrSize - 1 : vars.get(i + 1);
                while (k > j) {
                    this.instructions.get((int)k).ofs -= shrink;
                    --k;
                }
            }
            this.codeSize -= shrink;
        } while (changes);
    }

    public int findEndIdxOrLast(int startIdx, int len) {
        return this.findIdxOrLast(this.instructions.get((int)startIdx).ofs + len);
    }

    public int findIdxOrLast(int ofs) {
        if (ofs == this.codeSize) {
            return this.instructions.size();
        }
        return this.findIdx(ofs);
    }

    public int findIdx(int ofs) {
        int low = 0;
        int high = this.instructions.size() - 1;
        while (low <= high) {
            int idx = (low + high) / 2;
            int tmp = this.instructions.get((int)idx).ofs;
            if (tmp < ofs) {
                low = idx + 1;
                continue;
            }
            if (tmp > ofs) {
                high = idx - 1;
                continue;
            }
            return idx;
        }
        throw new RuntimeException("no such ofs: " + ofs);
    }

    public int findEndOfsOrLast(int startIdx, int idx) {
        return this.findOfsOrLast(idx) - this.findOfs(startIdx);
    }

    public int findOfsOrLast(int idx) {
        if (idx == this.instructions.size()) {
            return this.codeSize;
        }
        return this.findOfs(idx);
    }

    public int findOfs(int idx) {
        return this.instructions.get((int)this.resolveLabel((int)idx)).ofs;
    }

    public int resolveLabel(int idx) {
        if (idx < 0) {
            int trueIdx = this.labels.get(-idx);
            if (trueIdx < 0) {
                throw new RuntimeException("undefined label: " + idx);
            }
            return trueIdx;
        }
        return idx;
    }

    public int declareLabel() {
        this.labels.add(-1);
        return -(this.labels.size() - 1);
    }

    public void defineLabel(int label) {
        if (this.labels.get(-label) != -1) {
            throw new RuntimeException("duplicate definition for label " + label);
        }
        this.labels.set(-label, this.instructions.size());
    }

    public int currentLabel() {
        return this.instructions.size();
    }

    public String toString() {
        int i;
        StringBuilder result = new StringBuilder();
        result.append("Code attribute: \n");
        result.append("    locals=" + this.locals);
        result.append("    codeSize=" + this.codeSize + "\n");
        for (i = 0; i < this.instructions.size(); ++i) {
            Instruction instr = this.instructions.get(i);
            result.append(i + "\t(" + instr.ofs + ")\t" + instr.toString() + "\n");
        }
        for (i = 0; i < this.exceptions.size(); ++i) {
            result.append('\t');
            result.append(this.exceptions.get(i).toString());
            result.append('\n');
        }
        for (i = 0; i < this.attributes.size(); ++i) {
            result.append('\t');
            result.append(this.attributes.get(i).toString());
            result.append('\n');
        }
        return result.toString();
    }

    public void emitGeneric(int opcode, Object[] args) {
        InstructionType type = Set.TYPES[opcode];
        Instruction instr = new Instruction(-1, type, args);
        this.instructions.add(instr);
    }

    public void emit(int opcode) {
        this.emitGeneric(opcode, new Object[0]);
    }

    public void emit(int opcode, int arg) {
        this.emitGeneric(opcode, new Object[]{arg});
    }

    public void emit(int opcode, int arg0, int arg1) {
        this.emitGeneric(opcode, new Object[]{arg0, arg1});
    }

    public void emit(int opcode, String arg) {
        this.emitGeneric(opcode, new Object[]{arg});
    }

    public void emit(int opcode, MethodRef arg) {
        this.emitGeneric(opcode, new Object[]{arg});
    }

    public void emit(int opcode, ClassRef arg) {
        this.emitGeneric(opcode, new Object[]{arg});
    }

    public void emit(int opcode, FieldRef arg) {
        this.emitGeneric(opcode, new Object[]{arg});
    }

    public void emit(int opcode, int a, int b, int c, IntArrayList d) {
        this.emitGeneric(opcode, new Object[]{a, b, c, d});
    }

    public void emit(int opcode, int a, IntArrayList b, IntArrayList c) {
        this.emitGeneric(opcode, new Object[]{a, b, c});
    }

    public int declareFixup() {
        int result = this.instructions.size();
        this.emit(0);
        return result;
    }

    public void fixupGeneric(int fixup, int opcode, Object[] args) {
        InstructionType type = Set.TYPES[opcode];
        Instruction instr = new Instruction(-1, type, args);
        this.instructions.set(fixup, instr);
    }

    public void fixup(int fixup, int opcode) {
        this.fixupGeneric(fixup, opcode, new Object[0]);
    }

    public void fixup(int fixup, int opcode, int arg) {
        this.fixupGeneric(fixup, opcode, new Object[]{arg});
    }

    public void fixup(int fixup, int opcode, int arg0, int arg1) {
        this.fixupGeneric(fixup, opcode, new Object[]{arg0, arg1});
    }

    public void fixup(int fixup, int opcode, String arg) {
        this.fixupGeneric(fixup, opcode, new Object[]{arg});
    }

    public void fixup(int fixup, int opcode, MethodRef arg) {
        this.fixupGeneric(fixup, opcode, new Object[]{arg});
    }

    public void fixup(int fixup, int opcode, ClassRef arg) {
        this.fixupGeneric(fixup, opcode, new Object[]{arg});
    }

    public void fixup(int fixup, int opcode, FieldRef arg) {
        this.fixupGeneric(fixup, opcode, new Object[]{arg});
    }

    public void fixup(int fixup, int opcode, int a, int b, int c, IntArrayList d) {
        this.fixupGeneric(fixup, opcode, new Object[]{a, b, c, d});
    }

    public void fixup(int fixup, int opcode, int a, IntArrayList b, IntArrayList c) {
        this.fixupGeneric(fixup, opcode, new Object[]{a, b, c});
    }

    private int calcStackSize() {
        int i;
        List<Jsr> jsrs = Jsr.findJsrs(this);
        int[] startStack = new int[this.instructions.size()];
        for (i = 0; i < startStack.length; ++i) {
            startStack[i] = -1;
        }
        startStack[0] = 0;
        IntBitSet todo = new IntBitSet();
        todo.add(0);
        int max = this.exceptions.size();
        for (i = 0; i < max; ++i) {
            ExceptionInfo e = this.exceptions.get(i);
            startStack[e.handler] = 1;
            todo.add(e.handler);
        }
        this.fillStack(jsrs, todo, startStack);
        int result = 0;
        int unreachable = -1;
        for (i = 0; i < startStack.length; ++i) {
            int tmp = startStack[i];
            if (tmp > result) {
                result = tmp;
            }
            if (unreachable != -1 || tmp != -1) continue;
            unreachable = i;
        }
        if (unreachable != -1) {
            LOGGER.warning("unreachable code, starting " + unreachable + "\n");
        }
        return result;
    }

    private void fillStack(List<Jsr> jsrs, IntBitSet todo, int[] startStack) {
        int idx;
        block0: while ((idx = todo.first()) != -1) {
            todo.remove(idx);
            Instruction instr = this.instructions.get(idx);
            int succSize = startStack[idx] + instr.getStackDiff();
            if (succSize < 0) {
                throw new RuntimeException("stack size <0, idx: " + idx);
            }
            IntArrayList succBuffer = new IntArrayList();
            instr.getSuccessors(jsrs, idx, this, (IntCollection)succBuffer);
            int max = succBuffer.size();
            int i = 0;
            while (true) {
                if (i >= max) continue block0;
                int succIdx = succBuffer.get(i);
                int tmp = startStack[succIdx];
                if (tmp != succSize) {
                    if (tmp == -1) {
                        startStack[succIdx] = succSize;
                        todo.add(succIdx);
                    } else {
                        throw new RuntimeException("wrong stack idx = " + succIdx + ": " + tmp + "!=" + succSize + "\n" + this.toString());
                    }
                }
                ++i;
            }
            break;
        }
        return;
    }

    public int allocate(ClassRef cl) {
        int result = this.locals;
        this.locals += cl.operandSize();
        return result;
    }
}

