/*
 * Decompiled with CFR 0.152.
 */
package net.oneandone.mork.classfile;

import java.io.IOException;
import net.oneandone.mork.classfile.ClassRef;
import net.oneandone.mork.classfile.Input;
import net.oneandone.mork.classfile.Output;

public class ExceptionInfo {
    public int start;
    public int end;
    public int handler;
    public ClassRef type;

    public ExceptionInfo(int start, int end, int handler, ClassRef type) {
        this.start = start;
        this.end = end;
        this.handler = handler;
        this.type = type;
    }

    public ExceptionInfo(Input src) throws IOException {
        src.requireCode();
        this.start = src.readIdx();
        this.end = src.readIdxOrLast();
        this.handler = src.readIdx();
        try {
            this.type = src.readClassRef();
        }
        catch (NullPointerException e) {
            this.type = null;
        }
    }

    public void write(Output dest) throws IOException {
        dest.requireCode();
        dest.writeIdx(this.start);
        dest.writeIdxOrLast(this.end);
        dest.writeIdx(this.handler);
        try {
            dest.writeClassRef(this.type);
        }
        catch (NullPointerException e) {
            dest.writeU2(0);
        }
    }

    public String toString() {
        return "start=" + this.start + " end=" + this.end + " handler=" + this.handler + " type=" + this.type;
    }
}

