/*
 * Decompiled with CFR 0.152.
 */
package net.oneandone.mork.classfile;

import java.io.IOException;
import java.util.Set;
import net.oneandone.mork.classfile.Access;
import net.oneandone.mork.classfile.ClassRef;
import net.oneandone.mork.classfile.Definition;
import net.oneandone.mork.classfile.FieldRef;
import net.oneandone.mork.classfile.Input;
import net.oneandone.mork.classfile.Output;
import net.oneandone.mork.classfile.attribute.Attribute;

public class FieldDef
extends Definition {
    public final Set<Access> accessFlags;
    public final String name;
    public final ClassRef type;
    public Attribute[] attributes;

    public FieldDef(Set<Access> accessFlags, String name, ClassRef type) {
        this.accessFlags = accessFlags;
        this.name = name;
        this.type = type;
        this.attributes = new Attribute[0];
    }

    public FieldDef(Input src) throws IOException {
        this.accessFlags = Access.fromFlags(src.readU2(), false);
        this.name = src.readUtf8();
        String descriptor = src.readUtf8();
        this.type = ClassRef.forFieldDescriptor(descriptor);
        this.attributes = new Attribute[src.readU2()];
        for (int i = 0; i < this.attributes.length; ++i) {
            this.attributes[i] = Attribute.create(src);
        }
    }

    public void write(Output dest) throws IOException {
        dest.writeU2(Access.toFlags(this.accessFlags));
        dest.writeUtf8(this.name);
        dest.writeUtf8(this.type.toFieldDescriptor());
        dest.writeU2(this.attributes.length);
        for (int i = 0; i < this.attributes.length; ++i) {
            this.attributes[i].write(dest);
        }
    }

    public FieldRef reference(ClassRef owner) {
        return new FieldRef(owner, this.name, this.type);
    }

    public String toString() {
        return Access.toPrefix(this.accessFlags) + this.type + " " + this.name;
    }
}

