/*
 * Decompiled with CFR 0.152.
 */
package net.oneandone.mork.classfile;

import java.lang.reflect.Field;
import net.oneandone.mork.classfile.ClassDef;
import net.oneandone.mork.classfile.ClassRef;
import net.oneandone.mork.classfile.Constants;
import net.oneandone.mork.classfile.FieldDef;
import net.oneandone.mork.classfile.Reference;
import net.oneandone.mork.classfile.Repository;
import net.oneandone.mork.classfile.ResolveException;

public class FieldRef
extends Reference
implements Constants {
    public final ClassRef owner;
    public final String name;
    public final ClassRef type;

    public FieldRef(ClassRef owner, String name, ClassRef type) {
        this.owner = owner;
        this.name = name;
        this.type = type;
    }

    public FieldRef(Field field) {
        this.owner = new ClassRef(field.getDeclaringClass());
        this.name = field.getName();
        this.type = new ClassRef(field.getType());
    }

    @Override
    public ClassRef getOwner() {
        return this.owner;
    }

    @Override
    public FieldDef lookup(Repository repository) throws ResolveException {
        return this.lookup((ClassDef)this.owner.resolve(repository), repository);
    }

    private FieldDef lookup(ClassDef def, Repository repository) throws ResolveException {
        FieldDef field = def.lookupField(this.name);
        if (field != null) {
            return field;
        }
        for (ClassRef next : def.interfaces) {
            field = this.lookup((ClassDef)next.resolve(repository), repository);
            if (field == null) continue;
            return field;
        }
        if (def.superClass != null) {
            return this.lookup((ClassDef)def.superClass.resolve(repository), repository);
        }
        return null;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof FieldRef)) {
            return false;
        }
        FieldRef ref = (FieldRef)obj;
        return this.owner.equals(ref.owner) && this.name.equals(ref.name) && this.type.equals(ref.type);
    }

    public int hashCode() {
        return this.name.hashCode();
    }

    public String toString() {
        return this.type + " " + this.owner + "." + this.name;
    }
}

