/*
 * Decompiled with CFR 0.152.
 */
package net.oneandone.mork.classfile;

import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public class IO {
    public static int padSize(int ofs) {
        return (ofs + 3 & 0xFFFFFFFC) - ofs;
    }

    public static void read(InputStream src, byte[] buffer) throws IOException {
        IO.read(src, buffer, 0, buffer.length);
    }

    public static void read(InputStream src, byte[] buffer, int ofs, int len) throws IOException {
        while (len != 0) {
            int count = src.read(buffer, ofs, len);
            if (count == -1) {
                throw new EOFException();
            }
            ofs += count;
            len -= count;
        }
    }

    public static int readU1(InputStream src) throws IOException {
        int result = src.read();
        if (result == -1) {
            throw new EOFException();
        }
        return result;
    }

    public static int readS1(InputStream src) throws IOException {
        int result = src.read();
        if (result == -1) {
            throw new EOFException();
        }
        return (byte)result;
    }

    public static char readU2(InputStream src) throws IOException {
        int a = src.read();
        int b = src.read();
        if (a == -1 || b == -1) {
            throw new EOFException();
        }
        return (char)(a << 8 | b);
    }

    public static int readS2(InputStream src) throws IOException {
        int a = src.read();
        int b = src.read();
        if (a == -1 || b == -1) {
            throw new EOFException();
        }
        return (short)(a << 8 | b);
    }

    public static int readU4(InputStream src) throws IOException {
        int a = src.read();
        int b = src.read();
        int c = src.read();
        int d = src.read();
        if (a == -1 || b == -1 || c == -1 || d == -1) {
            throw new EOFException();
        }
        return a << 24 | b << 16 | c << 8 | d;
    }

    public static void write(OutputStream dest, byte[] data, int ofs, int len) throws IOException {
        dest.write(data, ofs, len);
    }

    public static void writeU1(OutputStream dest, int u1) throws IOException {
        if ((u1 & 0xFFFFFF00) != 0) {
            throw new IllegalArgumentException();
        }
        dest.write(u1 & 0xFF);
    }

    public static void writeS1(OutputStream dest, int s1) throws IOException {
        if (s1 < -128 || s1 > 127) {
            throw new IllegalArgumentException();
        }
        dest.write(s1 & 0xFF);
    }

    public static void writeU2(OutputStream dest, int u2) throws IOException {
        if (u2 < 0 || u2 > 65535) {
            throw new IllegalArgumentException();
        }
        dest.write((byte)(u2 >> 8));
        dest.write((byte)u2);
    }

    public static void writeS2(OutputStream dest, int s2) throws IOException {
        if (s2 < Short.MIN_VALUE || s2 > Short.MAX_VALUE) {
            throw new IllegalArgumentException();
        }
        dest.write((byte)(s2 >> 8));
        dest.write((byte)s2);
    }

    public static void writeU4(OutputStream dest, int u4) throws IOException {
        dest.write((byte)(u4 >> 24));
        dest.write((byte)(u4 >> 16));
        dest.write((byte)(u4 >> 8));
        dest.write((byte)u4);
    }
}

