/*
 * Decompiled with CFR 0.152.
 */
package net.oneandone.mork.classfile;

import java.io.IOException;
import net.oneandone.mork.classfile.ClassRef;
import net.oneandone.mork.classfile.Input;
import net.oneandone.mork.classfile.Output;

public class InnerClassesInfo {
    public ClassRef inner;
    public ClassRef outer;
    public String name;
    public int flags;
    public static final int SIZE = 8;

    public InnerClassesInfo(Input src) throws IOException {
        try {
            this.inner = src.readClassRef();
        }
        catch (NullPointerException e) {
            this.inner = null;
        }
        try {
            this.outer = src.readClassRef();
        }
        catch (NullPointerException e) {
            this.outer = null;
        }
        try {
            this.name = src.readUtf8();
        }
        catch (NullPointerException e) {
            this.name = null;
        }
        this.flags = src.readU2();
    }

    public void write(Output dest) throws IOException {
        try {
            dest.writeClassRef(this.inner);
        }
        catch (NullPointerException e) {
            dest.writeU2(0);
        }
        try {
            dest.writeClassRef(this.outer);
        }
        catch (NullPointerException e) {
            dest.writeU2(0);
        }
        try {
            dest.writeUtf8(this.name);
        }
        catch (NullPointerException e) {
            dest.writeU2(0);
        }
        dest.writeU2(this.flags);
    }
}

