/*
 * Decompiled with CFR 0.152.
 */
package net.oneandone.mork.classfile;

import java.io.IOException;
import java.io.InputStream;
import net.oneandone.mork.classfile.ClassDef;
import net.oneandone.mork.classfile.ClassRef;
import net.oneandone.mork.classfile.Code;
import net.oneandone.mork.classfile.Constants;
import net.oneandone.mork.classfile.FieldRef;
import net.oneandone.mork.classfile.IO;
import net.oneandone.mork.classfile.MethodRef;
import net.oneandone.mork.classfile.Pool;
import net.oneandone.sushi.fs.Node;

public class Input
implements Constants,
AutoCloseable {
    private InputStream src;
    private Code context;
    private int ofs;
    public char minor;
    public char major;
    public Pool constants;

    public static ClassDef load(Node node) throws IOException {
        ClassDef result;
        try (InputStream src = node.newInputStream();
             Input input = new Input(src);){
            result = new ClassDef(input);
        }
        catch (RuntimeException e) {
            throw new RuntimeException(node + ": " + e.getMessage(), e);
        }
        return result;
    }

    public Input(InputStream src) throws IOException {
        this.src = src;
        this.context = null;
        int u4 = this.readU4();
        if (u4 != -889275714) {
            throw new IOException("not a class file (magic='" + u4 + "')");
        }
        this.minor = this.readU2();
        this.major = this.readU2();
        this.constants = new Pool();
        this.constants.load(src);
    }

    @Override
    public void close() throws IOException {
        this.src.close();
    }

    public void openCode(Code code) {
        if (this.context != null) {
            throw new RuntimeException("nested code attributes");
        }
        this.context = code;
        this.ofs = 0;
    }

    public void closeCode() {
        if (this.context == null) {
            throw new RuntimeException("nested close");
        }
        this.context = null;
    }

    public void requireCode() {
        if (this.context == null) {
            throw new RuntimeException("code context missing");
        }
    }

    public int readIdx() throws IOException {
        return this.context.findIdx(this.readU2());
    }

    public int readIdxOrLast() throws IOException {
        return this.context.findIdxOrLast(this.readU2());
    }

    public int readEndIdxOrLast(int startIdx) throws IOException {
        return this.context.findEndIdxOrLast(startIdx, this.readU2());
    }

    public int getOfs() {
        return this.ofs;
    }

    public void read(byte[] buffer) throws IOException {
        IO.read(this.src, buffer);
        this.ofs += buffer.length;
    }

    public int readU1() throws IOException {
        int result = IO.readU1(this.src);
        ++this.ofs;
        return result;
    }

    public int readS1() throws IOException {
        int result = IO.readS1(this.src);
        ++this.ofs;
        return result;
    }

    public char readU2() throws IOException {
        char result = IO.readU2(this.src);
        this.ofs += 2;
        return result;
    }

    public int readS2() throws IOException {
        int result = IO.readS2(this.src);
        this.ofs += 2;
        return result;
    }

    public int readU4() throws IOException {
        int result = IO.readU4(this.src);
        this.ofs += 4;
        return result;
    }

    public ClassRef readClassRef() throws IOException {
        return (ClassRef)this.readConstant();
    }

    public FieldRef readFieldRef() throws IOException {
        return (FieldRef)this.readConstant();
    }

    public MethodRef readClassMethodRef() throws IOException {
        MethodRef result = (MethodRef)this.readConstant();
        if (result.ifc) {
            throw new RuntimeException("not a class method");
        }
        return result;
    }

    public MethodRef readInterfaceMethodRef() throws IOException {
        MethodRef result = (MethodRef)this.readConstant();
        if (!result.ifc) {
            throw new RuntimeException("not an interface method");
        }
        return result;
    }

    public String readString() throws IOException {
        return (String)this.readConstant();
    }

    public int readInt() throws IOException {
        return (Integer)this.readConstant();
    }

    public float readFloat() throws IOException {
        return ((Float)this.readConstant()).floatValue();
    }

    public long readLong() throws IOException {
        return (Long)this.readConstant();
    }

    public double readDouble() throws IOException {
        return (Double)this.readConstant();
    }

    public String readUtf8() throws IOException {
        return (String)this.readConstant();
    }

    public Object readConstant() throws IOException {
        char idx = this.readU2();
        if (idx == '\u0000') {
            throw new NullPointerException("null constant pool index");
        }
        return this.constants.get(idx);
    }

    public Object readShortConstant() throws IOException {
        int idx = this.readU1();
        if (idx == 0) {
            throw new NullPointerException("null constant pool short index");
        }
        return this.constants.get(idx);
    }

    public void readPad() throws IOException {
        int count = IO.padSize(this.ofs);
        while (count-- > 0) {
            int b = this.readU1();
            if (b == 0) continue;
            throw new RuntimeException("illegal pad");
        }
    }

    public int findConstant(Object obj) {
        return this.constants.indexOf(obj);
    }
}

