/*
 * Decompiled with CFR 0.152.
 */
package net.oneandone.mork.classfile;

import java.io.IOException;
import java.util.List;
import net.oneandone.mork.classfile.Code;
import net.oneandone.mork.classfile.Constants;
import net.oneandone.mork.classfile.FieldRef;
import net.oneandone.mork.classfile.Input;
import net.oneandone.mork.classfile.InstructionEncoding;
import net.oneandone.mork.classfile.InstructionType;
import net.oneandone.mork.classfile.Jsr;
import net.oneandone.mork.classfile.MethodRef;
import net.oneandone.mork.classfile.Output;
import net.oneandone.mork.classfile.Set;
import net.oneandone.sushi.util.IntArrayList;
import net.oneandone.sushi.util.IntCollection;

public class Instruction
implements Constants {
    public int ofs;
    public final InstructionType type;
    public final Object[] arguments;

    public Instruction(int ofsInit, InstructionType typeInit, Object[] argumentsInit) {
        this.ofs = ofsInit;
        this.type = typeInit;
        this.arguments = argumentsInit;
        this.type.checkArgs(this.arguments);
    }

    public int getMaxLength(Output dest) {
        return this.type.getMaxLength(dest, this.arguments);
    }

    public static Instruction read(Input src) throws IOException {
        int ofs = src.getOfs();
        int opcode = src.readU1();
        InstructionEncoding encoding = Set.ENCODING[opcode];
        if (encoding == null) {
            throw new RuntimeException("illegal opcode: " + opcode);
        }
        return encoding.read(opcode, src, ofs);
    }

    public void write(Output dest) throws IOException {
        this.type.write(dest, this.arguments);
    }

    public void ofsToIdx(Code context) {
        this.type.ofsToIdx(context, this.ofs, this.arguments);
    }

    public int getVariableLength(Code context) {
        return this.type.getVariableLength(context, this.ofs, this.arguments);
    }

    public void getSuccessors(List<Jsr> jsrs, int idx, Code code, IntCollection result) {
        switch (this.type.succType) {
            case 0: {
                break;
            }
            case 1: {
                result.add(idx + 1);
                break;
            }
            case 2: {
                result.add(code.resolveLabel((Integer)this.arguments[0]));
                break;
            }
            case 3: {
                result.add(idx + 1);
                result.add(code.resolveLabel((Integer)this.arguments[0]));
                break;
            }
            case 4: {
                result.add(code.resolveLabel((Integer)this.arguments[0]));
                IntArrayList tmp = (IntArrayList)this.arguments[2];
                int max = tmp.size();
                for (int i = 0; i < max; ++i) {
                    result.add(code.resolveLabel(tmp.get(i)));
                }
                break;
            }
            case 5: {
                result.add(code.resolveLabel((Integer)this.arguments[0]));
                IntArrayList tmp = (IntArrayList)this.arguments[3];
                int max = tmp.size();
                for (int i = 0; i < max; ++i) {
                    result.add(code.resolveLabel(tmp.get(i)));
                }
                break;
            }
            case 6: {
                result.add(code.resolveLabel((Integer)this.arguments[0]));
                break;
            }
            case 7: {
                Jsr.addRetSuccessors(jsrs, idx, result);
                break;
            }
            default: {
                throw new RuntimeException("successor not supported: " + this.type.succType);
            }
        }
    }

    public int getStackDiff() {
        switch (this.type.stackDiff) {
            case 1011: {
                return -((Integer)this.arguments[1]).intValue() + 1;
            }
            case 1012: {
                MethodRef m = (MethodRef)this.arguments[0];
                return -1 - m.argSize() + m.returnType.operandSize();
            }
            case 1013: {
                MethodRef m = (MethodRef)this.arguments[0];
                return -1 - m.argSize() + m.returnType.operandSize();
            }
            case 1014: {
                MethodRef m = (MethodRef)this.arguments[0];
                return -m.argSize() + m.returnType.operandSize();
            }
            case 1015: {
                MethodRef m = (MethodRef)this.arguments[0];
                return -1 - m.argSize() + m.returnType.operandSize();
            }
            case 1016: {
                return ((FieldRef)this.arguments[0]).type.operandSize();
            }
            case 1017: {
                return -((FieldRef)this.arguments[0]).type.operandSize();
            }
            case 1018: {
                return -1 + ((FieldRef)this.arguments[0]).type.operandSize();
            }
            case 1019: {
                return -1 - ((FieldRef)this.arguments[0]).type.operandSize();
            }
            case 1020: {
                Object obj = this.arguments[0];
                if (obj == null) {
                    return 1;
                }
                if (obj instanceof Long) {
                    return 2;
                }
                if (obj instanceof Double) {
                    return 2;
                }
                if (!(obj instanceof Object)) break;
                return 1;
            }
        }
        if (this.type.stackDiff >= 1021) {
            throw new RuntimeException("illegal stackDiff: " + this.type.stackDiff);
        }
        return this.type.stackDiff;
    }

    public String toString() {
        StringBuilder result = new StringBuilder();
        result.append(this.type.name);
        for (int i = 0; i < this.arguments.length; ++i) {
            result.append(' ');
            result.append("" + this.arguments[i]);
        }
        return result.toString();
    }
}

