/*
 * Decompiled with CFR 0.152.
 */
package net.oneandone.mork.classfile;

import java.io.IOException;
import net.oneandone.mork.classfile.Bytecodes;
import net.oneandone.mork.classfile.Constants;
import net.oneandone.mork.classfile.Input;
import net.oneandone.mork.classfile.Instruction;
import net.oneandone.mork.classfile.InstructionType;
import net.oneandone.mork.classfile.MethodRef;
import net.oneandone.mork.classfile.Set;
import net.oneandone.sushi.util.IntArrayList;

public class InstructionEncoding
implements Bytecodes,
Constants {
    public final String name;
    public final int[] args;
    public final InstructionType type;

    public InstructionEncoding(String name, int[] args, InstructionType type) {
        this.name = name;
        this.args = args;
        this.type = type;
    }

    public Instruction read(int opcode, Input src, int ofs) throws IOException {
        switch (opcode) {
            case 196: {
                return InstructionEncoding.readWide(src, ofs);
            }
            case 170: {
                return this.readTableSwitch(src, ofs);
            }
            case 171: {
                return this.readLookupSwitch(src, ofs);
            }
        }
        return this.readNormal(src, ofs);
    }

    private Instruction readTableSwitch(Input src, int ofs) throws IOException {
        src.readPad();
        int deflt = src.readU4();
        int low = src.readU4();
        int high = src.readU4();
        int max = high - low + 1;
        IntArrayList branches = new IntArrayList();
        Object[] args = new Object[]{new Integer(deflt), new Integer(low), new Integer(high), branches};
        for (int i = 0; i < max; ++i) {
            branches.add(src.readU4());
        }
        return new Instruction(ofs, this.type, args);
    }

    private Instruction readLookupSwitch(Input src, int ofs) throws IOException {
        src.readPad();
        int deflt = src.readU4();
        int count = src.readU4();
        IntArrayList keys = new IntArrayList();
        IntArrayList branches = new IntArrayList();
        Object[] args = new Object[]{new Integer(deflt), keys, branches};
        for (int i = 0; i < count; ++i) {
            keys.add(src.readU4());
            branches.add(src.readU4());
        }
        return new Instruction(ofs, this.type, args);
    }

    private static Instruction readWide(Input src, int ofs) throws IOException {
        Object[] args;
        int b = src.readU1();
        switch (b) {
            case 132: {
                args = new Object[]{(int)src.readU2(), src.readS2()};
                break;
            }
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 54: 
            case 55: 
            case 56: 
            case 57: 
            case 58: 
            case 169: {
                args = new Object[]{(int)src.readU2()};
                break;
            }
            default: {
                throw new RuntimeException("illegal iinc");
            }
        }
        return new Instruction(ofs, Set.TYPES[b], args);
    }

    private Instruction readNormal(Input src, int ofs) throws IOException {
        Object[] argValues = new Object[this.args.length];
        for (int i = 0; i < this.args.length; ++i) {
            argValues[i] = InstructionEncoding.readArg(src, this.args[i]);
        }
        return new Instruction(ofs, this.type, argValues);
    }

    private static Object readArg(Input src, int argType) throws IOException {
        switch (argType) {
            case 15: {
                return new Integer(src.readU1());
            }
            case 16: {
                return new Integer(src.readS1());
            }
            case 17: {
                return new Integer(src.readU2());
            }
            case 18: {
                return new Integer(src.readS2());
            }
            case 19: {
                return new Integer(src.readU4());
            }
            case 20: {
                return src.readClassRef();
            }
            case 21: {
                return src.readFieldRef();
            }
            case 22: {
                MethodRef ifc = src.readInterfaceMethodRef();
                int tmp = src.readU1();
                if (tmp != 1 + ifc.argSize()) {
                    throw new RuntimeException(ifc + ": illegal ifc arg size: " + tmp);
                }
                if (src.readU1() != 0) {
                    throw new RuntimeException("0 expected");
                }
                return ifc;
            }
            case 23: {
                return src.readClassMethodRef();
            }
            case 24: {
                return src.readShortConstant();
            }
            case 25: 
            case 26: {
                return src.readConstant();
            }
        }
        if (argType <= 14) {
            return IMPLICIT[argType];
        }
        throw new IllegalArgumentException("illegal arg type: " + argType);
    }

    public String toString() {
        StringBuilder result = new StringBuilder();
        result.append(this.name);
        for (int i = 0; i < this.args.length; ++i) {
            result.append(' ');
            result.append("" + this.args[i]);
        }
        return result.toString();
    }
}

