/*
 * Decompiled with CFR 0.152.
 */
package net.oneandone.mork.classfile;

import java.io.IOException;
import net.oneandone.mork.classfile.Bytecodes;
import net.oneandone.mork.classfile.ClassRef;
import net.oneandone.mork.classfile.Code;
import net.oneandone.mork.classfile.Constants;
import net.oneandone.mork.classfile.FieldRef;
import net.oneandone.mork.classfile.IO;
import net.oneandone.mork.classfile.MethodRef;
import net.oneandone.mork.classfile.Output;
import net.oneandone.mork.classfile.Set;
import net.oneandone.sushi.util.IntArrayList;

public class InstructionType
implements Bytecodes,
Constants {
    public final int opcode;
    public final String name;
    public final int stackDiff;
    public final int succType;
    public final int[] args;
    public final int encoding;
    public int length;

    public InstructionType(String nameInit, int opcodeInit, int[] argsInit, int encodingInit, int stackDiffInit, int succTypeInit) {
        this.name = nameInit;
        this.opcode = opcodeInit;
        this.args = argsInit;
        this.encoding = encodingInit;
        this.stackDiff = stackDiffInit;
        this.succType = succTypeInit;
        this.calcLength();
    }

    public void checkArgs(Object[] argValues) {
        switch (this.encoding) {
            case 0: {
                this.checkSimpleArgs(argValues);
                break;
            }
            case 1: 
            case 3: {
                if (argValues.length != 1) {
                    throw new RuntimeException("1 arg expected: " + this + " " + argValues);
                }
                if (argValues[0] instanceof Integer) break;
                throw new RuntimeException("Integer arg expected: " + this + " " + argValues[0]);
            }
            case 2: {
                if (argValues.length != 2) {
                    throw new RuntimeException("2 args expected: " + this + " " + argValues);
                }
                if (!(argValues[0] instanceof Integer)) {
                    throw new RuntimeException("Integer arg expected: " + this + " " + argValues[0]);
                }
                if (argValues[1] instanceof Integer) break;
                throw new RuntimeException("Integer arg 2 expected: " + this + " " + argValues[1]);
            }
            case 4: 
            case 5: {
                if (argValues.length != 1) {
                    throw new RuntimeException("<>BRANCH: 1 arg expected: " + argValues.length);
                }
                if (argValues[0] instanceof Integer) break;
                throw new RuntimeException("Integer arg expected: " + this + " " + argValues[0]);
            }
            case 6: {
                if (argValues.length != 3) {
                    throw new RuntimeException("LS: 3 arg expected: " + argValues.length);
                }
                if (!(argValues[0] instanceof Integer)) {
                    throw new RuntimeException("Integer arg expected: " + this + " " + argValues[0]);
                }
                if (!(argValues[1] instanceof IntArrayList)) {
                    throw new RuntimeException("IntArrayList arg expected: " + this + " " + argValues[1]);
                }
                if (argValues[2] instanceof IntArrayList) break;
                throw new RuntimeException("IntArrayList arg expected: " + this + " " + argValues[2]);
            }
            case 7: {
                if (argValues.length != 4) {
                    throw new RuntimeException("TS: 4 arg expected: " + argValues.length);
                }
                if (!(argValues[0] instanceof Integer)) {
                    throw new RuntimeException("Integer arg expected: " + this + " " + argValues[0]);
                }
                if (!(argValues[1] instanceof Integer)) {
                    throw new RuntimeException("Integer arg expected: " + this + " " + argValues[1]);
                }
                if (!(argValues[2] instanceof Integer)) {
                    throw new RuntimeException("Integer arg expected: " + this + " " + argValues[2]);
                }
                if (argValues[3] instanceof IntArrayList) break;
                throw new RuntimeException("IntArrayList arg expected: " + this + " " + argValues[3]);
            }
            case 8: {
                if (argValues.length == 1) break;
                throw new RuntimeException("LDC: 1 arg expected: " + argValues.length);
            }
            default: {
                throw new RuntimeException("illegal encoding: " + this.encoding);
            }
        }
    }

    public void checkSimpleArgs(Object[] argValues) {
        if (this.args.length != argValues.length) {
            throw new RuntimeException("illegal argument count: " + this + ":" + argValues.length);
        }
        block7: for (int i = 0; i < this.args.length; ++i) {
            Object v = argValues[i];
            switch (this.args[i]) {
                case 0: {
                    if (v instanceof ClassRef) continue block7;
                    throw new RuntimeException("ClassRef expected: " + this + v);
                }
                case 1: {
                    if (v instanceof FieldRef) continue block7;
                    throw new RuntimeException("FieldRef expected: " + this + v);
                }
                case 2: {
                    if (v instanceof MethodRef) continue block7;
                    throw new RuntimeException("MethodRef expected: " + this + v);
                }
                case 3: {
                    if (v instanceof MethodRef) continue block7;
                    throw new RuntimeException("MethodRef expected: " + this + v);
                }
                case 4: 
                case 5: {
                    if (v instanceof Integer) continue block7;
                    throw new RuntimeException("Integer expected: " + this + v);
                }
                default: {
                    throw new RuntimeException("illegal argument type: " + this.args[i]);
                }
            }
        }
    }

    private void calcLength() {
        if (this.encoding != 0) {
            this.length = -1;
        } else {
            this.length = 1;
            block5: for (int i = 0; i < this.args.length; ++i) {
                switch (this.args[i]) {
                    case 4: 
                    case 5: {
                        ++this.length;
                        continue block5;
                    }
                    case 0: 
                    case 1: 
                    case 3: {
                        this.length += 2;
                        continue block5;
                    }
                    case 2: {
                        this.length += 4;
                        continue block5;
                    }
                    default: {
                        throw new IllegalArgumentException(this.name + ": illegal arg type: " + this.args[i]);
                    }
                }
            }
        }
    }

    public String toString() {
        return this.name + "=" + this.opcode;
    }

    public void ofsToIdx(Code context, int ofs, Object[] argValues) {
        switch (this.encoding) {
            case 7: {
                int i = (Integer)argValues[0];
                argValues[0] = new Integer(context.findIdx(ofs + i));
                IntArrayList branchesW = (IntArrayList)argValues[3];
                for (i = 0; i < branchesW.size(); ++i) {
                    branchesW.set(i, context.findIdx(ofs + branchesW.get(i)));
                }
                break;
            }
            case 6: {
                int i = (Integer)argValues[0];
                argValues[0] = new Integer(context.findIdx(ofs + i));
                IntArrayList branchesW = (IntArrayList)argValues[2];
                for (i = 0; i < branchesW.size(); ++i) {
                    branchesW.set(i, context.findIdx(ofs + branchesW.get(i)));
                }
                break;
            }
            case 4: 
            case 5: {
                int i = (Integer)argValues[0];
                argValues[0] = new Integer(context.findIdx(ofs + i));
                break;
            }
        }
    }

    private static int branch(int srcOfs, int destIdx, Output context) {
        return context.getCode().findOfs(destIdx) - srcOfs;
    }

    public void write(Output dest, Object[] values) throws IOException {
        switch (this.encoding) {
            case 0: {
                this.writeSimple(dest, values);
                break;
            }
            case 8: {
                this.writeCNST(dest, values[0]);
                break;
            }
            case 4: {
                int i = InstructionType.branch(dest.getOfs(), (Integer)values[0], dest);
                if (Short.MIN_VALUE <= i && i <= Short.MAX_VALUE) {
                    dest.writeU1(this.opcode);
                    dest.writeS2(i);
                    break;
                }
                dest.writeU1(this.args[0]);
                dest.writeS2(8);
                dest.writeU1(200);
                dest.writeU4(i - 3);
                break;
            }
            case 5: {
                int i = InstructionType.branch(dest.getOfs(), (Integer)values[0], dest);
                if (Short.MIN_VALUE <= i && i <= Short.MAX_VALUE) {
                    dest.writeU1(this.opcode);
                    dest.writeS2(i);
                    break;
                }
                dest.writeU1(this.args[0]);
                dest.writeU4(i);
                break;
            }
            case 7: {
                int ofs = dest.getOfs();
                dest.writeU1(this.opcode);
                dest.writePad();
                dest.writeU4(InstructionType.branch(ofs, (Integer)values[0], dest));
                dest.writeU4((Integer)values[1]);
                dest.writeU4((Integer)values[2]);
                IntArrayList ofss = (IntArrayList)values[3];
                for (int i = 0; i < ofss.size(); ++i) {
                    dest.writeU4(InstructionType.branch(ofs, ofss.get(i), dest));
                }
                break;
            }
            case 6: {
                int ofs = dest.getOfs();
                dest.writeU1(this.opcode);
                dest.writePad();
                dest.writeU4(InstructionType.branch(ofs, (Integer)values[0], dest));
                IntArrayList keys = (IntArrayList)values[1];
                IntArrayList ofss = (IntArrayList)values[2];
                dest.writeU4(keys.size());
                for (int i = 0; i < keys.size(); ++i) {
                    dest.writeU4(keys.get(i));
                    dest.writeU4(InstructionType.branch(ofs, ofss.get(i), dest));
                }
                break;
            }
            case 1: {
                int i = (Integer)values[0];
                if (i < 0) {
                    throw new RuntimeException("LV < 0 " + i);
                }
                if (i <= 3) {
                    dest.writeU1(this.args[i]);
                    break;
                }
                if (i <= 255) {
                    dest.writeU1(this.opcode);
                    dest.writeU1(i);
                    break;
                }
                if (i <= 65535) {
                    dest.writeU1(196);
                    dest.writeU1(this.opcode);
                    dest.writeU2(i);
                    break;
                }
                throw new RuntimeException();
            }
            case 3: {
                int i = (Integer)values[0];
                if (i <= 255) {
                    dest.writeU1(this.opcode);
                    dest.writeU1(i);
                    break;
                }
                dest.writeU1(196);
                dest.writeU1(this.opcode);
                dest.writeU2(i);
                break;
            }
            case 2: {
                int i = (Integer)values[0];
                int i2 = (Integer)values[1];
                if (i <= 255 && -128 <= i2 && i2 <= 127) {
                    dest.writeU1(this.opcode);
                    dest.writeU1(i);
                    dest.writeS1(i2);
                    break;
                }
                dest.writeU1(196);
                dest.writeU1(this.opcode);
                dest.writeU2(i);
                dest.writeS2(i2);
                break;
            }
            default: {
                throw new RuntimeException("unknown encoding: " + this.encoding);
            }
        }
    }

    private void writeSimple(Output dest, Object[] values) throws IOException {
        dest.writeU1(this.opcode);
        block7: for (int i = 0; i < this.args.length; ++i) {
            Object val = values[i];
            switch (this.args[i]) {
                case 0: {
                    dest.writeClassRef((ClassRef)val);
                    continue block7;
                }
                case 1: {
                    dest.writeFieldRef((FieldRef)val);
                    continue block7;
                }
                case 3: {
                    dest.writeClassMethodRef((MethodRef)val);
                    continue block7;
                }
                case 2: {
                    MethodRef ifc = (MethodRef)val;
                    dest.writeInterfaceMethodRef((MethodRef)val);
                    dest.writeU1(1 + ifc.argSize());
                    dest.writeU1(0);
                    continue block7;
                }
                case 4: 
                case 5: {
                    dest.writeU1((Integer)val);
                    continue block7;
                }
                default: {
                    throw new RuntimeException("illegal argType: " + this.args[i]);
                }
            }
        }
    }

    public void writeCNST(Output dest, Object val) throws IOException {
        int e = this.findConstEncoding(dest, val);
        dest.writeU1(e);
        int ae = Set.ENCODING[e].args[0];
        switch (ae) {
            case 15: {
                dest.writeU1((Integer)val);
                break;
            }
            case 16: {
                dest.writeS1((Integer)val);
                break;
            }
            case 17: {
                dest.writeU2((Integer)val);
                break;
            }
            case 18: {
                dest.writeS2((Integer)val);
                break;
            }
            case 24: {
                if (val instanceof Integer) {
                    dest.writeShortInt((Integer)val);
                    break;
                }
                if (val instanceof Float) {
                    dest.writeShortFloat(((Float)val).floatValue());
                    break;
                }
                dest.writeShortString((String)val);
                break;
            }
            case 25: {
                if (val instanceof Integer) {
                    dest.writeInt((Integer)val);
                    break;
                }
                if (val instanceof Float) {
                    dest.writeFloat(((Float)val).floatValue());
                    break;
                }
                dest.writeString((String)val);
                break;
            }
            case 26: {
                if (val instanceof Long) {
                    dest.writeLong((Long)val);
                    break;
                }
                dest.writeDouble((Double)val);
                break;
            }
            default: {
                if (ae <= 14) break;
                throw new IllegalArgumentException(this.name + ": illegal arg encoding: " + ae);
            }
        }
    }

    public boolean isVariable() {
        switch (this.encoding) {
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                return true;
            }
        }
        return false;
    }

    public int getVariableLength(Code context, int ofs, Object[] argValues) {
        switch (this.encoding) {
            case 7: {
                return 1 + IO.padSize(ofs + 1) + 12 + ((IntArrayList)argValues[3]).size() * 4;
            }
            case 6: {
                return 1 + IO.padSize(ofs + 1) + 8 + ((IntArrayList)argValues[1]).size() * 4 * 2;
            }
            case 4: {
                int tmp = context.findOfs((Integer)argValues[0]) - ofs;
                if (Short.MIN_VALUE <= tmp && tmp <= Short.MAX_VALUE) {
                    return 3;
                }
                return 8;
            }
            case 5: {
                int tmp = context.findOfs((Integer)argValues[0]) - ofs;
                if (Short.MIN_VALUE <= tmp && tmp <= Short.MAX_VALUE) {
                    return 3;
                }
                return 5;
            }
        }
        throw new RuntimeException("not of variable length: " + this.encoding);
    }

    public int getMaxLength(Output dest, Object[] argValues) {
        switch (this.encoding) {
            case 0: {
                return this.length;
            }
            case 8: {
                return this.constLength(dest, argValues[0]);
            }
            case 4: {
                return 8;
            }
            case 5: {
                return 5;
            }
            case 7: {
                return 16 + ((IntArrayList)argValues[3]).size() * 4;
            }
            case 6: {
                return 12 + ((IntArrayList)argValues[1]).size() * 2 * 4;
            }
            case 1: {
                int i = (Integer)argValues[0];
                if (i < 0) {
                    throw new RuntimeException("LV to small: " + i);
                }
                if (i <= 3) {
                    return 1;
                }
                if (i <= 255) {
                    return 2;
                }
                if (i <= 65535) {
                    return 4;
                }
                throw new RuntimeException("LV to big: " + i);
            }
            case 3: {
                int i = (Integer)argValues[0];
                if (i <= 255) {
                    return 2;
                }
                return 4;
            }
            case 2: {
                int i = (Integer)argValues[0];
                int i2 = (Integer)argValues[1];
                if (i <= 255 && -128 <= i2 && i2 <= 127) {
                    return 3;
                }
                return 6;
            }
        }
        throw new RuntimeException("unknown encoding: " + this.encoding);
    }

    private int constLength(Output dest, Object cnst) {
        int e = this.findConstEncoding(dest, cnst);
        switch (e) {
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 14: 
            case 15: {
                return 1;
            }
            case 16: 
            case 18: {
                return 2;
            }
            case 17: 
            case 19: 
            case 20: {
                return 3;
            }
        }
        throw new RuntimeException("illegal constant: " + e);
    }

    private int findConstEncoding(Output dest, Object cnst) {
        int idx;
        boolean twice;
        if (cnst == null) {
            return 1;
        }
        if (cnst instanceof Integer) {
            int v = (Integer)cnst;
            switch (v) {
                case -1: {
                    return 2;
                }
                case 0: {
                    return 3;
                }
                case 1: {
                    return 4;
                }
                case 2: {
                    return 5;
                }
                case 3: {
                    return 6;
                }
                case 4: {
                    return 7;
                }
                case 5: {
                    return 8;
                }
            }
            if (-128 <= v && v <= 127) {
                return 16;
            }
            if (Short.MIN_VALUE <= v && v <= Short.MAX_VALUE) {
                return 17;
            }
            twice = false;
            idx = dest.addIfNew(3, cnst);
        } else if (cnst instanceof String) {
            twice = false;
            idx = dest.addIfNew(8, cnst);
        } else if (cnst instanceof Long) {
            if (IMPLICIT[8].equals(cnst)) {
                return 9;
            }
            if (IMPLICIT[9].equals(cnst)) {
                return 10;
            }
            twice = true;
            idx = dest.addIfNew(5, cnst);
        } else if (cnst instanceof Float) {
            if (IMPLICIT[10].equals(cnst)) {
                return 11;
            }
            if (IMPLICIT[11].equals(cnst)) {
                return 12;
            }
            twice = false;
            idx = dest.addIfNew(4, cnst);
        } else if (cnst instanceof Double) {
            if (IMPLICIT[13].equals(cnst)) {
                return 14;
            }
            if (IMPLICIT[14].equals(cnst)) {
                return 15;
            }
            twice = true;
            idx = dest.addIfNew(6, cnst);
        } else {
            throw new RuntimeException("illegal constant: " + cnst);
        }
        if (!twice && idx <= 255) {
            return 18;
        }
        return twice ? 20 : 19;
    }
}

