/*
 * Decompiled with CFR 0.152.
 */
package net.oneandone.mork.classfile;

import java.util.ArrayList;
import java.util.List;
import net.oneandone.mork.classfile.Bytecodes;
import net.oneandone.mork.classfile.Code;
import net.oneandone.mork.classfile.Instruction;
import net.oneandone.sushi.util.IntArrayList;
import net.oneandone.sushi.util.IntBitSet;
import net.oneandone.sushi.util.IntCollection;

public class Jsr
implements Bytecodes {
    public final int start;
    public final IntArrayList caller;
    public final IntArrayList rets;

    public Jsr(int startInit, Code code) {
        if (startInit < 0) {
            throw new IllegalArgumentException("start < 0: " + startInit);
        }
        this.start = startInit;
        this.caller = new IntArrayList();
        this.rets = new IntArrayList();
        this.calcRets(code);
    }

    private void calcRets(Code code) {
        Instruction instr;
        int idx;
        ArrayList<Jsr> empty = new ArrayList<Jsr>();
        IntBitSet todo = new IntBitSet();
        todo.add(this.start);
        IntBitSet reached = new IntBitSet();
        while ((idx = todo.first()) != -1) {
            todo.remove(idx);
            if (reached.contains(idx)) continue;
            reached.add(idx);
            instr = code.instructions.get(idx);
            instr.getSuccessors(empty, idx, code, (IntCollection)todo);
        }
        idx = reached.first();
        while (idx != -1) {
            instr = code.instructions.get(idx);
            if (instr.type.opcode == 169) {
                this.rets.add(idx);
            }
            idx = reached.next(idx);
        }
    }

    public String toString() {
        StringBuilder result = new StringBuilder();
        result.append("jsr " + this.start);
        result.append(" rets: " + this.rets);
        result.append(" caller: " + this.caller);
        return result.toString();
    }

    public static List<Jsr> findJsrs(Code code) {
        ArrayList<Jsr> result = new ArrayList<Jsr>();
        int max = code.instructions.size();
        for (int idx = 0; idx < max; ++idx) {
            Instruction instr = code.instructions.get(idx);
            if (instr.type.opcode != 168) continue;
            int start = code.resolveLabel((Integer)instr.arguments[0]);
            Jsr jsr = Jsr.findJsr(result, start);
            if (jsr == null) {
                jsr = new Jsr(start, code);
                result.add(jsr);
            }
            jsr.caller.add(idx);
        }
        return result;
    }

    public static Jsr findJsr(List<Jsr> jsrs, int st) {
        int max = jsrs.size();
        for (int i = 0; i < max; ++i) {
            Jsr result = jsrs.get(i);
            if (result.start != st) continue;
            return result;
        }
        return null;
    }

    public static void addRetSuccessors(List<Jsr> jsrs, int idx, IntCollection result) {
        int max = jsrs.size();
        for (int i = 0; i < max; ++i) {
            jsrs.get(i).addRetSuccessors(idx, result);
        }
    }

    public void addRetSuccessors(int idx, IntCollection result) {
        if (this.rets.indexOf(idx) != -1) {
            int max = this.caller.size();
            for (int i = 0; i < max; ++i) {
                result.add(this.caller.get(i) + 1);
            }
        }
    }
}

