/*
 * Decompiled with CFR 0.152.
 */
package net.oneandone.mork.classfile;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import net.oneandone.mork.classfile.Access;
import net.oneandone.mork.classfile.ClassRef;
import net.oneandone.mork.classfile.Code;
import net.oneandone.mork.classfile.Definition;
import net.oneandone.mork.classfile.Input;
import net.oneandone.mork.classfile.MethodRef;
import net.oneandone.mork.classfile.Output;
import net.oneandone.mork.classfile.attribute.Attribute;
import net.oneandone.mork.classfile.attribute.Exceptions;

public class MethodDef
extends Definition {
    public Set<Access> accessFlags;
    public String name;
    public ClassRef[] argumentTypes;
    public ClassRef returnType;
    public final List<Attribute> attributes = new ArrayList<Attribute>();

    public MethodDef() {
    }

    public MethodDef(Input src) throws IOException {
        this();
        this.accessFlags = Access.fromFlags(src.readU2(), false);
        this.name = src.readUtf8();
        String descriptor = src.readUtf8();
        this.argumentTypes = MethodRef.forArgumentTypes(descriptor);
        this.returnType = MethodRef.forReturnType(descriptor);
        int max = src.readU2();
        for (int i = 0; i < max; ++i) {
            this.attributes.add(Attribute.create(src));
        }
    }

    public void write(Output dest) throws IOException {
        dest.writeU2(Access.toFlags(this.accessFlags));
        dest.writeUtf8(this.name);
        dest.writeUtf8(MethodRef.toDescriptor(this.argumentTypes, this.returnType));
        int max = this.attributes.size();
        dest.writeU2(max);
        for (int i = 0; i < max; ++i) {
            this.attributes.get(i).write(dest);
        }
    }

    public List<ClassRef> getExceptions() {
        for (Attribute a : this.attributes) {
            if (!(a instanceof Exceptions)) continue;
            return ((Exceptions)a).exceptions;
        }
        return new ArrayList<ClassRef>();
    }

    public Code getCode() {
        for (Attribute a : this.attributes) {
            if (!(a instanceof Code)) continue;
            return (Code)a;
        }
        return null;
    }

    public MethodRef reference(ClassRef owner, boolean ifc) {
        return new MethodRef(owner, ifc, this.returnType, this.name, this.argumentTypes);
    }

    public String toString() {
        StringBuilder buffer = new StringBuilder(this.toSignatureString());
        buffer.append('\n');
        int max = this.attributes.size();
        for (int i = 0; i < max; ++i) {
            buffer.append(this.attributes.get(i).toString());
            buffer.append('\n');
        }
        return buffer.toString();
    }

    public String toSignatureString() {
        StringBuilder buffer = new StringBuilder(Access.toPrefix(this.accessFlags));
        buffer.append(this.returnType + " " + this.name + "(");
        for (int i = 0; i < this.argumentTypes.length; ++i) {
            if (i > 0) {
                buffer.append(", ");
            }
            buffer.append(this.argumentTypes[i]);
        }
        buffer.append(")");
        boolean first = true;
        for (ClassRef ref : this.getExceptions()) {
            if (first) {
                first = false;
                buffer.append(" throws ");
            } else {
                buffer.append(' ');
            }
            buffer.append(ref.toString());
        }
        return buffer.toString();
    }
}

