/*
 * Decompiled with CFR 0.152.
 */
package net.oneandone.mork.classfile;

import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.util.ArrayList;
import net.oneandone.mork.classfile.ClassDef;
import net.oneandone.mork.classfile.ClassRef;
import net.oneandone.mork.classfile.MethodDef;
import net.oneandone.mork.classfile.Reference;
import net.oneandone.mork.classfile.Repository;
import net.oneandone.mork.classfile.ResolveException;

public class MethodRef
extends Reference {
    public final ClassRef owner;
    public final boolean ifc;
    public final String name;
    public final ClassRef[] argumentTypes;
    public final ClassRef returnType;
    public static final String INIT = "<init>";

    public MethodRef(Method m) {
        this.owner = new ClassRef(m.getDeclaringClass());
        this.ifc = false;
        this.name = m.getName();
        Class<?>[] args = m.getParameterTypes();
        this.argumentTypes = new ClassRef[args.length];
        for (int i = 0; i < args.length; ++i) {
            this.argumentTypes[i] = new ClassRef(args[i]);
        }
        this.returnType = new ClassRef(m.getReturnType());
    }

    public MethodRef(Constructor<?> c) {
        this.owner = new ClassRef(c.getDeclaringClass());
        this.ifc = false;
        this.name = INIT;
        Class<?>[] args = c.getParameterTypes();
        this.argumentTypes = new ClassRef[args.length];
        for (int i = 0; i < args.length; ++i) {
            this.argumentTypes[i] = new ClassRef(args[i]);
        }
        this.returnType = ClassRef.VOID;
    }

    public MethodRef(ClassRef owner, boolean ifc, ClassRef returnType, String name, ClassRef ... argumentTypes) {
        this.owner = owner;
        this.ifc = ifc;
        this.name = name;
        this.argumentTypes = argumentTypes;
        this.returnType = returnType;
    }

    @Override
    public ClassRef getOwner() {
        return this.owner;
    }

    @Override
    public MethodDef lookup(Repository repository) throws ResolveException {
        return this.lookup((ClassDef)this.owner.resolve(repository), repository);
    }

    private MethodDef lookup(ClassDef def, Repository repository) throws ResolveException {
        MethodDef method = def.lookupMethod(this.name, this.argumentTypes);
        if (method != null && method.returnType.equals(this.returnType)) {
            return method;
        }
        for (ClassRef next : def.interfaces) {
            method = this.lookup((ClassDef)next.resolve(repository), repository);
            if (method == null) continue;
            return method;
        }
        if (def.superClass != null) {
            return this.lookup((ClassDef)def.superClass.resolve(repository), repository);
        }
        return null;
    }

    public static MethodRef meth(ClassRef owner, ClassRef returnType, String name) {
        return new MethodRef(owner, false, returnType, name, ClassRef.NONE);
    }

    public static MethodRef meth(ClassRef owner, ClassRef returnType, String name, ClassRef arg0) {
        return new MethodRef(owner, false, returnType, name, arg0);
    }

    public static MethodRef meth(ClassRef owner, ClassRef returnType, String name, ClassRef arg0, ClassRef arg1) {
        return new MethodRef(owner, false, returnType, name, arg0, arg1);
    }

    public static MethodRef meth(ClassRef owner, ClassRef returnType, String name, ClassRef arg0, ClassRef arg1, ClassRef arg2) {
        return new MethodRef(owner, false, returnType, name, arg0, arg1, arg2);
    }

    public static MethodRef meth(ClassRef owner, ClassRef returnType, String name, ClassRef arg0, ClassRef arg1, ClassRef arg2, ClassRef arg3) {
        return new MethodRef(owner, false, returnType, name, arg0, arg1, arg2, arg3);
    }

    public static MethodRef ifc(ClassRef owner, ClassRef returnType, String name) {
        return new MethodRef(owner, true, returnType, name, ClassRef.NONE);
    }

    public static MethodRef ifc(ClassRef owner, ClassRef returnType, String name, ClassRef arg0) {
        return new MethodRef(owner, true, returnType, name, arg0);
    }

    public static MethodRef ifc(ClassRef owner, ClassRef returnType, String name, ClassRef arg0, ClassRef arg1) {
        return new MethodRef(owner, true, returnType, name, arg0, arg1);
    }

    public static MethodRef ifc(ClassRef owner, ClassRef returnType, String name, ClassRef arg0, ClassRef arg1, ClassRef arg2) {
        return new MethodRef(owner, true, returnType, name, arg0, arg1, arg2);
    }

    public static MethodRef ifc(ClassRef owner, ClassRef returnType, String name, ClassRef arg0, ClassRef arg1, ClassRef arg2, ClassRef arg3) {
        return new MethodRef(owner, true, returnType, name, arg0, arg1, arg2, arg3);
    }

    public static MethodRef constr(ClassRef cl, ClassRef[] args) {
        return new MethodRef(cl, false, ClassRef.VOID, INIT, args);
    }

    public static MethodRef constr(ClassRef cl) {
        return MethodRef.constr(cl, ClassRef.NONE);
    }

    public static MethodRef constr(ClassRef cl, ClassRef arg0) {
        return MethodRef.constr(cl, new ClassRef[]{arg0});
    }

    public static MethodRef constr(ClassRef cl, ClassRef arg0, ClassRef arg1) {
        return MethodRef.constr(cl, new ClassRef[]{arg0, arg1});
    }

    public static MethodRef constr(ClassRef cl, ClassRef arg0, ClassRef arg1, ClassRef arg2) {
        return MethodRef.constr(cl, new ClassRef[]{arg0, arg1, arg2});
    }

    public static MethodRef constr(ClassRef cl, ClassRef arg0, ClassRef arg1, ClassRef arg2, ClassRef arg3) {
        return MethodRef.constr(cl, new ClassRef[]{arg0, arg1, arg2, arg3});
    }

    public int argSize() {
        int result = 0;
        for (int i = 0; i < this.argumentTypes.length; ++i) {
            result += this.argumentTypes[i].operandSize();
        }
        return result;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof MethodRef)) {
            return false;
        }
        MethodRef ref = (MethodRef)obj;
        if (!(this.owner.equals(ref.owner) && this.ifc == ref.ifc && this.name.equals(ref.name) && this.returnType.equals(ref.returnType) && this.argumentTypes.length == ref.argumentTypes.length)) {
            return false;
        }
        for (int i = 0; i < this.argumentTypes.length; ++i) {
            if (this.argumentTypes[i].equals(ref.argumentTypes[i])) continue;
            return false;
        }
        return true;
    }

    public int hashCode() {
        return this.name.hashCode();
    }

    public String toDescriptor() {
        return MethodRef.toDescriptor(this.argumentTypes, this.returnType);
    }

    public static String toDescriptor(ClassRef[] args, ClassRef result) {
        StringBuilder buffer = new StringBuilder();
        buffer.append('(');
        for (int i = 0; i < args.length; ++i) {
            buffer.append(args[i].toFieldDescriptor());
        }
        buffer.append(')');
        buffer.append(result.toFieldDescriptor());
        return buffer.toString();
    }

    public static ClassRef forReturnType(String descriptor) {
        int i = descriptor.indexOf(41);
        if (i == -1) {
            throw new RuntimeException();
        }
        return (ClassRef)ClassRef.forFieldDescriptor(descriptor, i + 1, descriptor.length())[0];
    }

    public static ClassRef[] forArgumentTypes(String descriptor) {
        int length = descriptor.length();
        if (length < 2 || descriptor.charAt(0) != '(') {
            throw new RuntimeException();
        }
        int ofs = 1;
        ArrayList<ClassRef> lst = new ArrayList<ClassRef>();
        while (ofs < length && descriptor.charAt(ofs) != ')') {
            Object[] tmp = ClassRef.forFieldDescriptor(descriptor, ofs, length);
            lst.add((ClassRef)tmp[0]);
            ofs = (Integer)tmp[1];
        }
        ClassRef[] result = new ClassRef[lst.size()];
        lst.toArray(result);
        return result;
    }

    public String toString() {
        StringBuilder result = new StringBuilder();
        result.append(this.returnType);
        result.append(' ');
        result.append(this.owner);
        result.append('.');
        result.append(this.name);
        result.append('(');
        for (int i = 0; i < this.argumentTypes.length; ++i) {
            if (i > 0) {
                result.append(", ");
            }
            result.append(this.argumentTypes[i]);
        }
        result.append(')');
        return result.toString();
    }
}

