/*
 * Decompiled with CFR 0.152.
 */
package net.oneandone.mork.classfile;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import net.oneandone.mork.classfile.ClassDef;
import net.oneandone.mork.classfile.ClassRef;
import net.oneandone.mork.classfile.Code;
import net.oneandone.mork.classfile.Constants;
import net.oneandone.mork.classfile.FieldRef;
import net.oneandone.mork.classfile.IO;
import net.oneandone.mork.classfile.MethodRef;
import net.oneandone.mork.classfile.Pool;
import net.oneandone.sushi.util.IntArrayList;

public class Output
implements Constants,
AutoCloseable {
    private final ByteArrayOutputStream bufferDest;
    private final OutputStream finalDest;
    private OutputStream dest;
    private Code context;
    private int codeStart;
    private final IntArrayList fixups;
    public char minor = '\u0000';
    public char major = (char)50;
    private final Pool constants;

    public static void save(ClassDef c, File file) throws IOException {
        try (FileOutputStream stream = new FileOutputStream(file);
             Output output = new Output(stream);){
            c.write(output);
        }
    }

    public Output(OutputStream dest) {
        this(dest, new Pool());
    }

    public Output(OutputStream destInit, Pool constantsInit) {
        this.bufferDest = new ByteArrayOutputStream();
        this.finalDest = destInit;
        this.dest = this.bufferDest;
        this.constants = constantsInit;
        this.context = null;
        this.codeStart = 0;
        this.fixups = new IntArrayList();
    }

    @Override
    public void close() throws IOException {
        this.dest.close();
        byte[] array = ((ByteArrayOutputStream)this.dest).toByteArray();
        this.dest = this.finalDest;
        this.writeU4(-889275714);
        this.writeU2(this.minor);
        this.writeU2(this.major);
        this.constants.write(this.dest);
        int max = this.fixups.size();
        int old = 0;
        for (int i = 0; i < max; i += 2) {
            int ofs = this.fixups.get(i);
            this.write(array, old, ofs - old);
            this.writeU4(this.fixups.get(i + 1));
            old = ofs + 4;
        }
        this.dest.write(array, old, array.length - old);
        this.dest.close();
    }

    public void openCode(Code code) {
        if (this.context != null) {
            throw new RuntimeException("nested code attribute");
        }
        this.context = code;
        this.codeStart = this.getGlobalOfs();
    }

    public void closeCode() {
        if (this.context == null) {
            throw new RuntimeException("no code attribute to close");
        }
        this.context = null;
    }

    public void requireCode() {
        if (this.context == null) {
            throw new RuntimeException("not int code attribute");
        }
    }

    public Code getCode() {
        return this.context;
    }

    public int getOfs() {
        return this.getGlobalOfs() - this.codeStart;
    }

    public void writeEndIdxOrLast(int startIdx, int idx) throws IOException {
        this.writeU2(this.context.findEndOfsOrLast(startIdx, idx));
    }

    public void writeIdxOrLast(int idx) throws IOException {
        this.writeU2(this.context.findOfsOrLast(idx));
    }

    public void writeIdx(int idx) throws IOException {
        this.writeU2(this.context.findOfs(idx));
    }

    public void write(byte[] data) throws IOException {
        this.write(data, 0, data.length);
    }

    public void write(byte[] data, int ofs, int len) throws IOException {
        IO.write(this.dest, data, ofs, len);
    }

    public void writeU1(int u1) throws IOException {
        IO.writeU1(this.dest, u1);
    }

    public void writeS1(int u1) throws IOException {
        IO.writeS1(this.dest, u1);
    }

    public void writeU2(int u2) throws IOException {
        IO.writeU2(this.dest, u2);
    }

    public void writeS2(int u2) throws IOException {
        IO.writeS2(this.dest, u2);
    }

    public void writeU4(int u4) throws IOException {
        IO.writeU4(this.dest, u4);
    }

    public void writeConstant(Object obj) throws IOException {
        if (obj instanceof ClassRef) {
            this.writeClassRef((ClassRef)obj);
        } else if (obj instanceof FieldRef) {
            this.writeFieldRef((FieldRef)obj);
        } else if (obj instanceof MethodRef) {
            MethodRef m = (MethodRef)obj;
            if (m.ifc) {
                this.writeInterfaceMethodRef(m);
            } else {
                this.writeClassMethodRef(m);
            }
        } else if (obj instanceof String) {
            this.writeString((String)obj);
        } else if (obj instanceof Integer) {
            this.writeInt((Integer)obj);
        } else if (obj instanceof Float) {
            this.writeFloat(((Float)obj).floatValue());
        } else if (obj instanceof Long) {
            this.writeLong((Long)obj);
        } else if (obj instanceof Double) {
            this.writeDouble((Double)obj);
        } else {
            throw new IllegalArgumentException("" + obj);
        }
    }

    public void writeClassRef(ClassRef ref) throws IOException {
        this.constants.write(this.dest, 7, ref);
    }

    public void writeFieldRef(FieldRef ref) throws IOException {
        this.constants.write(this.dest, 9, ref);
    }

    public void writeClassMethodRef(MethodRef ref) throws IOException {
        this.constants.write(this.dest, 10, ref);
    }

    public void writeInterfaceMethodRef(MethodRef ref) throws IOException {
        this.constants.write(this.dest, 11, ref);
    }

    public void writeString(String value) throws IOException {
        this.constants.write(this.dest, 8, value);
    }

    public void writeInt(int value) throws IOException {
        this.constants.write(this.dest, 3, new Integer(value));
    }

    public void writeFloat(float value) throws IOException {
        this.constants.write(this.dest, 4, new Float(value));
    }

    public void writeLong(long value) throws IOException {
        this.constants.write(this.dest, 5, new Long(value));
    }

    public void writeDouble(double value) throws IOException {
        this.constants.write(this.dest, 6, new Double(value));
    }

    public void writeShortString(String value) throws IOException {
        this.constants.writeShort(this.dest, 8, value);
    }

    public void writeShortInt(int value) throws IOException {
        this.constants.writeShort(this.dest, 3, new Integer(value));
    }

    public void writeShortFloat(float value) throws IOException {
        this.constants.writeShort(this.dest, 4, new Float(value));
    }

    public void writeUtf8(String value) throws IOException {
        this.constants.write(this.dest, 1, value);
    }

    public void writePad() throws IOException {
        int count = IO.padSize(this.getOfs());
        while (count-- > 0) {
            this.writeU1(0);
        }
    }

    public int addIfNew(int id, Object obj) {
        return this.constants.addIfNew(id, obj);
    }

    public int getGlobalOfs() {
        return this.bufferDest.size();
    }

    public int writeSpace(int size) throws IOException {
        int result = this.getGlobalOfs();
        while (size > 0) {
            this.writeU1(0);
            --size;
        }
        this.fixups.add(result);
        this.fixups.add(0);
        return result;
    }

    public void writeFixup(int fixup, int value) {
        int max = this.fixups.size();
        for (int i = 0; i < max; i += 2) {
            if (this.fixups.get(i) != fixup) continue;
            this.fixups.set(i + 1, value);
            return;
        }
        throw new IllegalArgumentException("so such fixup: " + fixup);
    }
}

