/*
 * Decompiled with CFR 0.152.
 */
package net.oneandone.mork.classfile;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;
import net.oneandone.mork.classfile.ClassRef;
import net.oneandone.mork.classfile.Constants;
import net.oneandone.mork.classfile.FieldRef;
import net.oneandone.mork.classfile.IO;
import net.oneandone.mork.classfile.MethodRef;
import net.oneandone.mork.classfile.NameAndType;

public class Pool
implements Constants {
    private final List<Object> objects;
    private final List<byte[]> bytes = new ArrayList<byte[]>();

    public Pool() {
        this.objects = new ArrayList<Object>();
        this.bytes.add(null);
        this.objects.add(null);
    }

    public int size() {
        return this.objects.size();
    }

    public void load(InputStream src) throws IOException {
        int i;
        int max = IO.readU2(src);
        for (i = 1; i < max; ++i) {
            byte[] tmp = Pool.readBytes(src);
            this.bytes.add(tmp);
            if (!Pool.isFat(tmp[0])) continue;
            ++i;
            this.bytes.add(null);
        }
        for (i = 1; i < max; ++i) {
            if (this.bytes.get(i) != null) {
                this.objects.add(this.createObject(i));
                continue;
            }
            this.objects.add(null);
        }
    }

    public void write(OutputStream dest) throws IOException {
        int max = this.objects.size();
        IO.writeU2(dest, max);
        for (int i = 1; i < max; ++i) {
            byte[] info = this.bytes.get(i);
            if (info == null) continue;
            IO.write(dest, info, 0, info.length);
        }
    }

    public Object get(int idx) {
        return this.objects.get(idx);
    }

    public int write(OutputStream dest, int id, Object obj) throws IOException {
        if (obj == null) {
            throw new NullPointerException("write null");
        }
        int idx = this.addIfNew(id, obj);
        IO.writeU2(dest, idx);
        return idx;
    }

    public int writeShort(OutputStream dest, int id, Object obj) throws IOException {
        int idx = this.addIfNew(id, obj);
        if (idx >>> 8 != 0) {
            throw new RuntimeException("idx not short " + idx);
        }
        IO.writeU1(dest, idx);
        return idx;
    }

    public int indexOf(Object obj) {
        return this.objects.indexOf(obj);
    }

    public int indexOf(int id, Object obj) {
        int max = this.bytes.size();
        for (int i = 0; i < max; ++i) {
            byte[] info = this.bytes.get(i);
            if (info == null || info[0] != id || !obj.equals(this.objects.get(i))) continue;
            return i;
        }
        return -1;
    }

    public int addIfNew(int id, Object obj) {
        int result = this.indexOf(id, obj);
        if (result == -1) {
            result = this.add(id, obj);
        }
        return result;
    }

    private int add(int id, Object obj) {
        byte[] tmp = this.createBytes(id, obj);
        int result = this.objects.size();
        this.objects.add(obj);
        this.bytes.add(tmp);
        if (Pool.isFat(id)) {
            this.objects.add(null);
            this.bytes.add(null);
        }
        return result;
    }

    private byte[] createBytes(int id, Object obj) {
        switch (id) {
            case 7: {
                return this.createClassRefBytes((ClassRef)obj);
            }
            case 9: {
                return this.createFieldRefBytes((FieldRef)obj);
            }
            case 10: 
            case 11: {
                return this.createMethodRefBytes((MethodRef)obj);
            }
            case 8: {
                return this.createStringBytes((String)obj);
            }
            case 3: {
                return this.createIntegerBytes((Integer)obj);
            }
            case 4: {
                return this.createFloatBytes((Float)obj);
            }
            case 5: {
                return this.createLongBytes((Long)obj);
            }
            case 6: {
                return this.createDoubleBytes((Double)obj);
            }
            case 12: {
                return this.createNameAndTypeBytes((NameAndType)obj);
            }
            case 1: {
                return Pool.toUtf8((String)obj);
            }
        }
        throw new RuntimeException();
    }

    private byte[] createClassRefBytes(ClassRef ref) {
        int i = this.addIfNew(1, ref.toDescriptor());
        return new byte[]{7, (byte)(i >> 8), (byte)i};
    }

    private byte[] createFieldRefBytes(FieldRef ref) {
        NameAndType tmp = new NameAndType(ref.name, ref);
        int a = this.addIfNew(7, ref.owner);
        int b = this.addIfNew(12, tmp);
        return new byte[]{9, (byte)(a >> 8), (byte)a, (byte)(b >> 8), (byte)b};
    }

    private byte[] createMethodRefBytes(MethodRef ref) {
        NameAndType tmp = new NameAndType(ref.name, ref);
        int a = this.addIfNew(7, ref.owner);
        int b = this.addIfNew(12, tmp);
        return new byte[]{ref.ifc ? (byte)11 : 10, (byte)(a >> 8), (byte)a, (byte)(b >> 8), (byte)b};
    }

    private byte[] createStringBytes(String value) {
        int a = this.addIfNew(1, value);
        return new byte[]{8, (byte)(a >> 8), (byte)a};
    }

    private byte[] createIntegerBytes(Integer value) {
        int i = value;
        return new byte[]{3, (byte)(i >> 24), (byte)(i >> 16), (byte)(i >> 8), (byte)i};
    }

    private byte[] createFloatBytes(Float value) {
        int i = Float.floatToIntBits(value.floatValue());
        return new byte[]{4, (byte)(i >> 24), (byte)(i >> 16), (byte)(i >> 8), (byte)i};
    }

    private byte[] createLongBytes(Long value) {
        long l = value;
        return new byte[]{5, (byte)(l >> 56), (byte)(l >> 48), (byte)(l >> 40), (byte)(l >> 32), (byte)(l >> 24), (byte)(l >> 16), (byte)(l >> 8), (byte)l};
    }

    private byte[] createDoubleBytes(Double value) {
        long l = Double.doubleToLongBits(value);
        return new byte[]{6, (byte)(l >> 56), (byte)(l >> 48), (byte)(l >> 40), (byte)(l >> 32), (byte)(l >> 24), (byte)(l >> 16), (byte)(l >> 8), (byte)l};
    }

    private byte[] createNameAndTypeBytes(NameAndType nt) {
        int a = this.addIfNew(1, nt.name);
        int b = this.addIfNew(1, nt.descriptor);
        return new byte[]{12, (byte)(a >> 8), (byte)a, (byte)(b >> 8), (byte)b};
    }

    private static byte[] readBytes(InputStream src) throws IOException {
        byte[] bytes;
        int id = src.read();
        if (id == -1) {
            return null;
        }
        int size = Pool.getData(id);
        if (size == -1) {
            size = IO.readU2(src);
            bytes = new byte[3 + size];
            bytes[1] = (byte)(size >> 8);
            bytes[2] = (byte)size;
            IO.read(src, bytes, 3, size);
        } else {
            bytes = new byte[1 + size];
            IO.read(src, bytes, 1, size);
        }
        bytes[0] = (byte)id;
        return bytes;
    }

    private Object createObject(int no) {
        byte[] info = this.bytes.get(no);
        switch (info[0]) {
            case 7: {
                String str = (String)this.createObject(Pool.bytesToU2(info, 1));
                if (str.startsWith("[")) {
                    return ClassRef.forFieldDescriptor(str);
                }
                return new ClassRef(str.replace('/', '.'));
            }
            case 8: {
                return this.createObject(Pool.bytesToU2(info, 1));
            }
            case 3: {
                return new Integer(Pool.bytesToU4(info, 1));
            }
            case 5: {
                return new Long(Pool.bytesToU8(info, 1));
            }
            case 4: {
                return new Float(Float.intBitsToFloat(Pool.bytesToU4(info, 1)));
            }
            case 6: {
                return new Double(Double.longBitsToDouble(Pool.bytesToU8(info, 1)));
            }
            case 9: {
                Object o1 = this.createObject(Pool.bytesToU2(info, 1));
                NameAndType nt = (NameAndType)this.createObject(Pool.bytesToU2(info, 3));
                return new FieldRef((ClassRef)o1, nt.name, ClassRef.forFieldDescriptor(nt.descriptor));
            }
            case 10: {
                Object o1 = this.createObject(Pool.bytesToU2(info, 1));
                NameAndType nt = (NameAndType)this.createObject(Pool.bytesToU2(info, 3));
                return new MethodRef((ClassRef)o1, false, MethodRef.forReturnType(nt.descriptor), nt.name, MethodRef.forArgumentTypes(nt.descriptor));
            }
            case 11: {
                Object o1 = this.createObject(Pool.bytesToU2(info, 1));
                NameAndType nt = (NameAndType)this.createObject(Pool.bytesToU2(info, 3));
                return new MethodRef((ClassRef)o1, true, MethodRef.forReturnType(nt.descriptor), nt.name, MethodRef.forArgumentTypes(nt.descriptor));
            }
            case 12: {
                Object o1 = this.createObject(Pool.bytesToU2(info, 1));
                Object o2 = this.createObject(Pool.bytesToU2(info, 3));
                return new NameAndType((String)o1, (String)o2);
            }
            case 1: {
                return Pool.fromUtf8(info, 3, Pool.bytesToU2(info, 1) + 3);
            }
        }
        throw new RuntimeException("unknown id: " + info[0]);
    }

    private static char bytesToU2(byte[] bytes, int ofs) {
        return (char)((bytes[ofs] & 0xFF) << 8 | bytes[ofs + 1] & 0xFF);
    }

    private static int bytesToU4(byte[] bytes, int ofs) {
        return (bytes[ofs + 0] & 0xFF) << 24 | (bytes[ofs + 1] & 0xFF) << 16 | (bytes[ofs + 2] & 0xFF) << 8 | bytes[ofs + 3] & 0xFF;
    }

    private static long bytesToU8(byte[] bytes, int ofs) {
        return (long)Pool.bytesToU4(bytes, ofs) << 32 | (long)Pool.bytesToU4(bytes, ofs + 4) & 0xFFFFFFFFFFFFFFFFL;
    }

    private static int getData(int id) {
        switch (id) {
            case 7: 
            case 8: {
                return 2;
            }
            case 3: 
            case 4: 
            case 9: 
            case 10: 
            case 11: 
            case 12: {
                return 4;
            }
            case 5: 
            case 6: {
                return 8;
            }
            case 1: {
                return -1;
            }
        }
        throw new RuntimeException("unknown id: " + id);
    }

    private static boolean isFat(int id) {
        switch (id) {
            case 1: 
            case 3: 
            case 4: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: {
                return false;
            }
            case 5: 
            case 6: {
                return true;
            }
        }
        throw new RuntimeException("unknown id: " + id);
    }

    public static String fromUtf8(byte[] info, int ofs, int max) {
        StringBuilder result = new StringBuilder(max - ofs);
        int i = ofs;
        while (i < max) {
            int c = info[i];
            if (c >= 0) {
                ++i;
            } else {
                switch (c & 0xE0) {
                    case 192: {
                        c = (c & 0x1F) << 6 | info[i + 1] & 0x3F;
                        i += 2;
                        break;
                    }
                    case 224: {
                        c = (c & 0x1F) << 12 | (info[i + 1] & 0x3F) << 6 | info[i + 2] & 0x3F;
                        i += 3;
                        break;
                    }
                    default: {
                        throw new RuntimeException("illegal utf8 byte: " + c);
                    }
                }
            }
            result.append((char)c);
        }
        return result.toString();
    }

    public static byte[] toUtf8(String str) {
        char c;
        int i;
        int max = str.length();
        int len = 0;
        for (i = 0; i < max; ++i) {
            c = str.charAt(i);
            if (c >= '\u0001' && c <= '\u007f') {
                ++len;
                continue;
            }
            if (c == '\u0000' || c >= '\u0080' && c <= '\u07ff') {
                len += 2;
                continue;
            }
            len += 3;
        }
        if (len > 65535) {
            throw new IllegalArgumentException("string too long: " + str.length() + "/" + len);
        }
        byte[] result = new byte[3 + len];
        result[0] = 1;
        result[1] = (byte)(len >> 8);
        result[2] = (byte)len;
        len = 3;
        for (i = 0; i < max; ++i) {
            c = str.charAt(i);
            if (c >= '\u0001' && c <= '\u007f') {
                result[len] = (byte)c;
                ++len;
                continue;
            }
            if (c == '\u0000' || c >= '\u0080' && c <= '\u07ff') {
                result[len + 0] = (byte)(c >> 6 | 0xC0);
                result[len + 1] = (byte)(c & 0x3F | 0x80);
                len += 2;
                continue;
            }
            result[len + 0] = (byte)(c >> 12 | 0xE0);
            result[len + 1] = (byte)(c >> 6 & 0x3F | 0x80);
            result[len + 2] = (byte)(c & 0x3F | 0x80);
            len += 3;
        }
        if (len != result.length) {
            throw new IllegalStateException(len + " vs " + result.length);
        }
        return result;
    }
}

