/*
 * Decompiled with CFR 0.152.
 */
package net.oneandone.mork.classfile;

import java.io.IOException;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import net.oneandone.mork.classfile.Access;
import net.oneandone.mork.classfile.ClassDef;
import net.oneandone.mork.classfile.ClassRef;
import net.oneandone.mork.classfile.Code;
import net.oneandone.mork.classfile.FieldDef;
import net.oneandone.mork.classfile.Input;
import net.oneandone.mork.classfile.MethodDef;
import net.oneandone.mork.classfile.MethodRef;
import net.oneandone.mork.classfile.Reference;
import net.oneandone.mork.classfile.Usage;
import net.oneandone.sushi.fs.Node;
import net.oneandone.sushi.fs.file.FileNode;

public class Repository {
    private final Repository parent;
    private final Map<String, ClassDef> defs;
    private final List<Node> lazy;

    public Repository() {
        this(null);
    }

    public Repository(Repository parent) {
        this.parent = parent;
        this.defs = new HashMap<String, ClassDef>();
        this.lazy = new ArrayList<Node>();
    }

    private Node getDir(Node file) throws IOException {
        return file.isFile() && file instanceof FileNode ? ((FileNode)file).openZip() : file;
    }

    public void addAll(Node<?> file) throws IOException {
        file.checkExists();
        Node dir = this.getDir(file);
        for (Node node : dir.find(new String[]{"**/*.class"})) {
            this.add(Input.load(node));
        }
    }

    public void addAllLazy(Node node) throws IOException {
        this.lazy.add(this.getDir(node));
    }

    public void add(ClassDef load) {
        this.defs.put(load.getName(), load);
    }

    public ClassDef lookup(String name) throws IOException {
        ClassDef result;
        ClassDef def = this.defs.get(name);
        if (def != null) {
            return def;
        }
        if (this.parent != null && (result = this.parent.lookup(name)) != null) {
            return result;
        }
        String path = ClassRef.classToResName(name);
        for (Node dir : this.lazy) {
            Node file = dir.join(new String[]{path});
            if (!file.isFile()) continue;
            def = Input.load(file);
            this.add(def);
            return def;
        }
        return null;
    }

    public ClassDef lookup(ClassDef c) throws IOException {
        ClassDef def = this.lookup(c.getName());
        if (def != null && def.accessFlags.equals(c.accessFlags) && def.superClass.equals(c.superClass) && def.interfaces.equals(c.interfaces)) {
            return def;
        }
        return null;
    }

    public void dump(PrintWriter dest) {
        for (ClassDef def : this.defs.values()) {
            dest.println(def.toString());
        }
    }

    public void diff(Repository rightSet, PrintWriter info) throws IOException {
        for (ClassDef left : this.defs.values()) {
            if (rightSet.lookup(left) != null) continue;
            info.println("- " + left.toSignatureString());
        }
        for (ClassDef right : rightSet.defs.values()) {
            if (this.lookup(right) != null) continue;
            info.println("+ " + right.toSignatureString());
        }
        for (ClassDef left : this.defs.values()) {
            ClassDef tmp = rightSet.lookup(left);
            if (tmp == null) continue;
            Repository.diffBody(left, tmp, info);
        }
    }

    public void defines(List<Reference> pblic, List<Reference> prvate) {
        for (ClassDef def : this.defs.values()) {
            ClassRef owner = def.reference();
            for (MethodDef m : def.methods) {
                (m.accessFlags.contains((Object)Access.PUBLIC) ? pblic : prvate).add(m.reference(owner, def.accessFlags.contains((Object)Access.INTERFACE)));
            }
            for (FieldDef f : def.fields) {
                (f.accessFlags.contains((Object)Access.PUBLIC) ? pblic : prvate).add(f.reference(owner));
            }
        }
    }

    public static void diffBody(ClassDef left, ClassDef right, PrintWriter info) {
        ArrayList<FieldDef> removedFields = new ArrayList<FieldDef>();
        ArrayList<FieldDef> addedFields = new ArrayList<FieldDef>();
        for (FieldDef lf : left.fields) {
            if (right.lookupField(lf) != null) continue;
            removedFields.add(lf);
        }
        for (FieldDef rf : right.fields) {
            if (left.lookupField(rf) != null) continue;
            addedFields.add(rf);
        }
        ArrayList<MethodDef> removedMethods = new ArrayList<MethodDef>();
        ArrayList<MethodDef> addedMethods = new ArrayList<MethodDef>();
        for (MethodDef lm : left.methods) {
            if (right.lookupMethod(lm) != null) continue;
            removedMethods.add(lm);
        }
        for (MethodDef rm : right.methods) {
            if (left.lookupMethod(rm) != null) continue;
            addedMethods.add(rm);
        }
        if (removedFields.size() > 0 || addedFields.size() > 0 || removedMethods.size() > 0 || addedMethods.size() > 0) {
            info.println("* " + left.toSignatureString());
            for (FieldDef f : removedFields) {
                info.println("  - " + f.toString() + ";");
            }
            for (FieldDef f : addedFields) {
                info.println("  + " + f.toString() + ";");
            }
            for (MethodDef m : removedMethods) {
                info.println("  - " + m.toSignatureString());
            }
            for (MethodDef m : addedMethods) {
                info.println("  + " + m.toSignatureString());
            }
        }
    }

    public void ref(List<Usage> result) {
        for (ClassDef def : this.defs.values()) {
            ClassRef owner = def.reference();
            for (MethodDef m : def.methods) {
                Code code = m.getCode();
                if (code == null) continue;
                MethodRef from = m.reference(owner, def.accessFlags.contains((Object)Access.INTERFACE));
                HashSet<Reference> refs = new HashSet<Reference>();
                code.references(refs);
                for (Reference ref : refs) {
                    result.add(new Usage(from, ref));
                }
            }
        }
    }
}

