/*
 * Decompiled with CFR 0.152.
 */
package net.oneandone.mork.classfile;

import java.lang.reflect.Field;
import net.oneandone.mork.classfile.Bytecodes;
import net.oneandone.mork.classfile.Constants;
import net.oneandone.mork.classfile.InstructionEncoding;
import net.oneandone.mork.classfile.InstructionType;

public class Set
implements Constants {
    public static final InstructionEncoding[] ENCODING = new InstructionEncoding[256];
    public static final InstructionType[] TYPES = new InstructionType[256];

    private static int[] a() {
        return new int[0];
    }

    private static int[] a(int a0) {
        return new int[]{a0};
    }

    private static int[] a(int a0, int a1) {
        return new int[]{a0, a1};
    }

    private static int getOpcode(String name) {
        Field f;
        try {
            f = Bytecodes.class.getField(name.toUpperCase());
        }
        catch (NoSuchFieldException e) {
            throw new RuntimeException("no such opcode: " + name);
        }
        try {
            return f.getInt(null);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException("can read field " + name);
        }
    }

    private static InstructionType type(String name, int[] args, int encoding, int stackDiff, int succType) {
        int opcode = Set.getOpcode(name);
        if (TYPES[opcode] != null) {
            throw new RuntimeException("duplicate type: " + opcode);
        }
        Set.TYPES[opcode] = new InstructionType(name, opcode, args, encoding, stackDiff, succType);
        return TYPES[opcode];
    }

    private static void enc(String name, int[] args, InstructionType type) {
        int opcode = Set.getOpcode(name);
        if (ENCODING[opcode] != null) {
            throw new RuntimeException("duplicate encoding: " + opcode);
        }
        Set.ENCODING[opcode] = new InstructionEncoding(name, args, type);
    }

    private static void generic(int encoding, String name, int[] typeArgs, int[] encArgs, int stackDiff, int succType) {
        InstructionType type = Set.type(name, typeArgs, encoding, stackDiff, succType);
        Set.enc(name, encArgs, type);
    }

    private static void simple(String name, int[] args, int stackDiff, int succType) {
        int[] encodedArgs = new int[args.length];
        block7: for (int i = 0; i < args.length; ++i) {
            switch (args[i]) {
                case 0: {
                    encodedArgs[i] = 20;
                    continue block7;
                }
                case 1: {
                    encodedArgs[i] = 21;
                    continue block7;
                }
                case 2: {
                    encodedArgs[i] = 22;
                    continue block7;
                }
                case 3: {
                    encodedArgs[i] = 23;
                    continue block7;
                }
                case 4: 
                case 5: {
                    encodedArgs[i] = 15;
                    continue block7;
                }
                default: {
                    throw new IllegalArgumentException(name + "[" + i + "]: " + args[i]);
                }
            }
        }
        Set.generic(0, name, args, encodedArgs, stackDiff, succType);
    }

    private static void lv(String name, int stackDiff) {
        String name0 = name + "_0";
        String name1 = name + "_1";
        String name2 = name + "_2";
        String name3 = name + "_3";
        int[] args = new int[]{Set.getOpcode(name0), Set.getOpcode(name1), Set.getOpcode(name2), Set.getOpcode(name3)};
        InstructionType type = Set.type(name, args, 1, stackDiff, 1);
        Set.enc(name, new int[]{15}, type);
        Set.enc(name0, new int[]{2}, type);
        Set.enc(name1, new int[]{3}, type);
        Set.enc(name2, new int[]{4}, type);
        Set.enc(name3, new int[]{5}, type);
    }

    private static void branch(String name, String notName, int stackDiff, int succType) {
        InstructionType type = Set.type(name, new int[]{Set.getOpcode(notName)}, 4, stackDiff, succType);
        Set.enc(name, new int[]{18}, type);
    }

    private static void vbranch(String name, int stackDiff, int succType) {
        String nameW = name + "_w";
        InstructionType type = Set.type(name, new int[]{Set.getOpcode(nameW)}, 5, stackDiff, succType);
        Set.enc(name, new int[]{18}, type);
        Set.enc(nameW, new int[]{19}, type);
    }

    private static void cnst(String name) {
        InstructionType t = Set.type(name, new int[0], 8, 1020, 1);
        Set.enc("aconst_null", Set.a(0), t);
        Set.enc("iconst_m1", Set.a(1), t);
        Set.enc("iconst_0", Set.a(2), t);
        Set.enc("iconst_1", Set.a(3), t);
        Set.enc("iconst_2", Set.a(4), t);
        Set.enc("iconst_3", Set.a(5), t);
        Set.enc("iconst_4", Set.a(6), t);
        Set.enc("iconst_5", Set.a(7), t);
        Set.enc("lconst_0", Set.a(8), t);
        Set.enc("lconst_1", Set.a(9), t);
        Set.enc("fconst_0", Set.a(10), t);
        Set.enc("fconst_1", Set.a(11), t);
        Set.enc("fconst_2", Set.a(12), t);
        Set.enc("dconst_0", Set.a(13), t);
        Set.enc("dconst_1", Set.a(14), t);
        Set.enc("bipush", Set.a(16), t);
        Set.enc("sipush", Set.a(18), t);
        Set.enc("ldc", Set.a(24), t);
        Set.enc("ldc_w", Set.a(25), t);
        Set.enc("ldc2_w", Set.a(26), t);
    }

    static {
        Set.enc("wide", new int[0], null);
        Set.simple("nop", Set.a(), 0, 1);
        Set.cnst("ldc");
        Set.lv("iload", 1);
        Set.lv("lload", 2);
        Set.lv("fload", 1);
        Set.lv("dload", 2);
        Set.lv("aload", 1);
        Set.generic(3, "ret", Set.a(), Set.a(15), 0, 7);
        Set.simple("iaload", Set.a(), -1, 1);
        Set.simple("laload", Set.a(), 0, 1);
        Set.simple("faload", Set.a(), -1, 1);
        Set.simple("daload", Set.a(), 0, 1);
        Set.simple("aaload", Set.a(), -1, 1);
        Set.simple("baload", Set.a(), -1, 1);
        Set.simple("caload", Set.a(), -1, 1);
        Set.simple("saload", Set.a(), -1, 1);
        Set.lv("istore", -1);
        Set.lv("lstore", -2);
        Set.lv("fstore", -1);
        Set.lv("dstore", -2);
        Set.lv("astore", -1);
        Set.simple("iastore", Set.a(), -3, 1);
        Set.simple("lastore", Set.a(), -4, 1);
        Set.simple("fastore", Set.a(), -3, 1);
        Set.simple("dastore", Set.a(), -4, 1);
        Set.simple("aastore", Set.a(), -3, 1);
        Set.simple("bastore", Set.a(), -3, 1);
        Set.simple("castore", Set.a(), -3, 1);
        Set.simple("sastore", Set.a(), -3, 1);
        Set.simple("pop", Set.a(), -1, 1);
        Set.simple("pop2", Set.a(), -2, 1);
        Set.simple("dup", Set.a(), 1, 1);
        Set.simple("dup_x1", Set.a(), 1, 1);
        Set.simple("dup_x2", Set.a(), 1, 1);
        Set.simple("dup2", Set.a(), 2, 1);
        Set.simple("dup2_x1", Set.a(), 2, 1);
        Set.simple("dup2_x2", Set.a(), 2, 1);
        Set.simple("swap", Set.a(), 0, 1);
        Set.simple("iadd", Set.a(), -1, 1);
        Set.simple("ladd", Set.a(), -2, 1);
        Set.simple("fadd", Set.a(), -1, 1);
        Set.simple("dadd", Set.a(), -2, 1);
        Set.simple("isub", Set.a(), -1, 1);
        Set.simple("lsub", Set.a(), -2, 1);
        Set.simple("fsub", Set.a(), -1, 1);
        Set.simple("dsub", Set.a(), -2, 1);
        Set.simple("imul", Set.a(), -1, 1);
        Set.simple("lmul", Set.a(), -2, 1);
        Set.simple("fmul", Set.a(), -1, 1);
        Set.simple("dmul", Set.a(), -2, 1);
        Set.simple("idiv", Set.a(), -1, 1);
        Set.simple("ldiv", Set.a(), -2, 1);
        Set.simple("fdiv", Set.a(), -1, 1);
        Set.simple("ddiv", Set.a(), -2, 1);
        Set.simple("irem", Set.a(), -1, 1);
        Set.simple("lrem", Set.a(), -2, 1);
        Set.simple("frem", Set.a(), -1, 1);
        Set.simple("drem", Set.a(), -2, 1);
        Set.simple("ineg", Set.a(), 0, 1);
        Set.simple("lneg", Set.a(), 0, 1);
        Set.simple("fneg", Set.a(), 0, 1);
        Set.simple("dneg", Set.a(), 0, 1);
        Set.simple("ishl", Set.a(), -1, 1);
        Set.simple("lshl", Set.a(), -1, 1);
        Set.simple("ishr", Set.a(), -1, 1);
        Set.simple("lshr", Set.a(), -1, 1);
        Set.simple("iushr", Set.a(), -1, 1);
        Set.simple("lushr", Set.a(), -1, 1);
        Set.simple("iand", Set.a(), -1, 1);
        Set.simple("land", Set.a(), -2, 1);
        Set.simple("ior", Set.a(), -1, 1);
        Set.simple("lor", Set.a(), -2, 1);
        Set.simple("ixor", Set.a(), -1, 1);
        Set.simple("lxor", Set.a(), -2, 1);
        Set.generic(2, "iinc", Set.a(), Set.a(15, 16), 0, 1);
        Set.simple("i2l", Set.a(), 1, 1);
        Set.simple("i2f", Set.a(), 0, 1);
        Set.simple("i2d", Set.a(), 1, 1);
        Set.simple("l2i", Set.a(), -1, 1);
        Set.simple("l2f", Set.a(), -1, 1);
        Set.simple("l2d", Set.a(), 0, 1);
        Set.simple("f2i", Set.a(), 0, 1);
        Set.simple("f2l", Set.a(), 1, 1);
        Set.simple("f2d", Set.a(), 1, 1);
        Set.simple("d2i", Set.a(), -1, 1);
        Set.simple("d2l", Set.a(), 0, 1);
        Set.simple("d2f", Set.a(), -1, 1);
        Set.simple("i2b", Set.a(), 0, 1);
        Set.simple("i2c", Set.a(), 0, 1);
        Set.simple("i2s", Set.a(), 0, 1);
        Set.simple("lcmp", Set.a(), -3, 1);
        Set.simple("fcmpl", Set.a(), -1, 1);
        Set.simple("fcmpg", Set.a(), -1, 1);
        Set.simple("dcmpl", Set.a(), -3, 1);
        Set.simple("dcmpg", Set.a(), -3, 1);
        Set.branch("ifeq", "ifne", -1, 3);
        Set.branch("ifne", "ifeq", -1, 3);
        Set.branch("iflt", "ifge", -1, 3);
        Set.branch("ifge", "iflt", -1, 3);
        Set.branch("ifgt", "ifle", -1, 3);
        Set.branch("ifle", "ifgt", -1, 3);
        Set.branch("if_icmpeq", "if_icmpne", -2, 3);
        Set.branch("if_icmpne", "if_icmpeq", -2, 3);
        Set.branch("if_icmplt", "if_icmpge", -2, 3);
        Set.branch("if_icmpge", "if_icmplt", -2, 3);
        Set.branch("if_icmpgt", "if_icmple", -2, 3);
        Set.branch("if_icmple", "if_icmpgt", -2, 3);
        Set.branch("if_acmpeq", "if_acmpne", -2, 3);
        Set.branch("if_acmpne", "if_acmpeq", -2, 3);
        Set.vbranch("goto", 0, 2);
        Set.vbranch("jsr", 1, 6);
        Set.generic(7, "tableswitch", Set.a(), Set.a(), -1, 5);
        Set.generic(6, "lookupswitch", Set.a(), Set.a(), -1, 4);
        Set.simple("ireturn", Set.a(), -1, 0);
        Set.simple("lreturn", Set.a(), -2, 0);
        Set.simple("freturn", Set.a(), -1, 0);
        Set.simple("dreturn", Set.a(), -2, 0);
        Set.simple("areturn", Set.a(), -1, 0);
        Set.simple("return", Set.a(), 0, 0);
        Set.simple("getstatic", Set.a(1), 1016, 1);
        Set.simple("putstatic", Set.a(1), 1017, 1);
        Set.simple("getfield", Set.a(1), 1018, 1);
        Set.simple("putfield", Set.a(1), 1019, 1);
        Set.simple("invokevirtual", Set.a(3), 1012, 1);
        Set.simple("invokespecial", Set.a(3), 1013, 1);
        Set.simple("invokestatic", Set.a(3), 1014, 1);
        Set.simple("invokeinterface", Set.a(2), 1015, 1);
        Set.simple("new", Set.a(0), 1, 1);
        Set.simple("newarray", Set.a(5), 0, 1);
        Set.simple("anewarray", Set.a(0), 0, 1);
        Set.simple("arraylength", Set.a(), 0, 1);
        Set.simple("athrow", Set.a(), 0, 0);
        Set.simple("checkcast", Set.a(0), 0, 1);
        Set.simple("instanceof", Set.a(0), 0, 1);
        Set.simple("monitorenter", Set.a(), -1, 1);
        Set.simple("monitorexit", Set.a(), -1, 1);
        Set.simple("multianewarray", Set.a(0, 4), 1011, 1);
        Set.branch("ifnull", "ifnonnull", -1, 3);
        Set.branch("ifnonnull", "ifnull", -1, 3);
    }
}

