/*
 * Decompiled with CFR 0.152.
 */
package net.oneandone.mork.classfile;

import net.oneandone.mork.classfile.Bytecodes;
import net.oneandone.mork.classfile.Constants;

public class Type
implements Bytecodes,
Constants {
    public final int id;
    public final String name;
    public final char descriptor;
    public final Class<?> type;
    public final Class<?> wrapper;
    public final Object zero;
    public final Object zeroLdc;
    public final int size;
    public final int load;
    public final int store;
    public final int arrayLoad;
    public final int arrayStore;
    private static final Integer ZERO = new Integer(0);
    public static final Type[] PRIMITIVES = new Type[]{new Type(3, 'V', Void.class, null, null, 0, -1, -1, -1, -1), new Type(4, 'Z', Boolean.class, new Boolean(false), ZERO, 1, 21, 54, 51, 84), new Type(5, 'C', Character.class, new Character('\u0000'), ZERO, 1, 21, 54, 52, 85), new Type(6, 'F', Float.class, new Float(0.0f), new Float(0.0f), 1, 23, 56, 48, 81), new Type(7, 'D', Double.class, new Double(0.0), new Double(0.0), 2, 24, 57, 49, 82), new Type(8, 'B', Byte.class, new Byte(0), ZERO, 1, 21, 54, 51, 84), new Type(9, 'S', Short.class, new Short(0), ZERO, 1, 21, 54, 53, 86), new Type(10, 'I', Integer.class, ZERO, ZERO, 1, 21, 54, 46, 79), new Type(11, 'J', Long.class, new Long(0L), new Long(0L), 2, 22, 55, 47, 80)};
    public static final Type REFERENCE = new Type(2, 'L', null, null, null, 1, 25, 58, 50, 83);

    private Type(int id, char descriptor, Class<?> wrapper, Object zero, Object zeroLdc, int size, int load, int store, int arrayLoad, int arrayStore) {
        this.id = id;
        this.type = Type.getPrimitive(wrapper);
        this.name = this.type == null ? null : this.type.getName();
        this.descriptor = descriptor;
        this.wrapper = wrapper;
        this.zero = zero;
        this.zeroLdc = zeroLdc;
        this.size = size;
        this.load = load;
        this.store = store;
        this.arrayLoad = arrayLoad;
        this.arrayStore = arrayStore;
    }

    private static Class<?> getPrimitive(Class<?> wrapper) {
        if (wrapper == null) {
            return null;
        }
        try {
            return (Class)wrapper.getDeclaredField("TYPE").get(null);
        }
        catch (IllegalAccessException | IllegalArgumentException | NoSuchFieldException | SecurityException e) {
            throw new RuntimeException(e);
        }
    }
}

