/*
 * Decompiled with CFR 0.152.
 */
package net.oneandone.mork.classfile.attribute;

import java.io.IOException;
import net.oneandone.mork.classfile.Code;
import net.oneandone.mork.classfile.Input;
import net.oneandone.mork.classfile.Output;
import net.oneandone.mork.classfile.attribute.Blackbox;
import net.oneandone.mork.classfile.attribute.ConstantValue;
import net.oneandone.mork.classfile.attribute.Deprecated;
import net.oneandone.mork.classfile.attribute.Exceptions;
import net.oneandone.mork.classfile.attribute.InnerClasses;
import net.oneandone.mork.classfile.attribute.LineNumberTable;
import net.oneandone.mork.classfile.attribute.LocalVariableTable;
import net.oneandone.mork.classfile.attribute.SourceFile;
import net.oneandone.mork.classfile.attribute.Synthetic;

public abstract class Attribute {
    public final String name;

    protected Attribute(String nameInit) {
        this.name = nameInit;
    }

    public static Attribute create(Input src) throws IOException {
        String name = src.readUtf8();
        if (name.equals("Code")) {
            return new Code(src);
        }
        if (name.equals("ConstantValue")) {
            return new ConstantValue(src);
        }
        if (name.equals("Exceptions")) {
            return new Exceptions(src);
        }
        if (name.equals("InnerClasses")) {
            return new InnerClasses(src);
        }
        if (name.equals("Synthetic")) {
            return new Synthetic(src);
        }
        if (name.equals("SourceFile")) {
            return new SourceFile(src);
        }
        if (name.equals("LineNumberTable")) {
            return new LineNumberTable(src);
        }
        if (name.equals("LocalVariableTable")) {
            return new LocalVariableTable(src);
        }
        if (name.equals("Deprecated")) {
            return new Deprecated(src);
        }
        return new Blackbox(name, src);
    }

    public abstract void write(Output var1) throws IOException;
}

