/*
 * Decompiled with CFR 0.152.
 */
package net.oneandone.mork.classfile.attribute;

import java.io.IOException;
import net.oneandone.mork.classfile.Input;
import net.oneandone.mork.classfile.Output;
import net.oneandone.mork.classfile.attribute.Attribute;

public class ConstantValue
extends Attribute {
    public static final String NAME = "ConstantValue";
    public final Object value;

    public ConstantValue(Object valueInit) {
        super(NAME);
        this.value = valueInit;
    }

    public ConstantValue(Input src) throws IOException {
        super(NAME);
        int len = src.readU4();
        if (len != 2) {
            throw new RuntimeException("ConstantValue attribute of length " + len);
        }
        this.value = src.readConstant();
    }

    @Override
    public void write(Output dest) throws IOException {
        dest.writeUtf8(this.name);
        dest.writeU4(2);
        dest.writeConstant(this.value);
    }

    public String toString() {
        return this.name + " attribute " + this.value;
    }
}

