/*
 * Decompiled with CFR 0.152.
 */
package net.oneandone.mork.classfile.attribute;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import net.oneandone.mork.classfile.ClassRef;
import net.oneandone.mork.classfile.Input;
import net.oneandone.mork.classfile.Output;
import net.oneandone.mork.classfile.attribute.Attribute;

public class Exceptions
extends Attribute {
    public static final String NAME = "Exceptions";
    public final List<ClassRef> exceptions = new ArrayList<ClassRef>();

    public Exceptions() {
        super(NAME);
    }

    public Exceptions(Input src) throws IOException {
        this();
        int len = src.readU4();
        int count = src.readU2();
        if (2 + count * 2 != len) {
            throw new RuntimeException("illegal exceptions attribute");
        }
        for (int i = 0; i < count; ++i) {
            this.exceptions.add(src.readClassRef());
        }
    }

    @Override
    public void write(Output dest) throws IOException {
        dest.writeUtf8(this.name);
        int start = dest.writeSpace(4);
        int count = this.exceptions.size();
        dest.writeU2(count);
        for (int i = 0; i < count; ++i) {
            dest.writeClassRef(this.exceptions.get(i));
        }
        dest.writeFixup(start, dest.getGlobalOfs() - (start + 4));
    }

    public String toString() {
        StringBuilder result = new StringBuilder();
        result.append(NAME);
        result.append(" attrib\n");
        int len = this.exceptions.size();
        for (int i = 0; i < len; ++i) {
            result.append('\t');
            result.append(this.exceptions.get(i).toString());
            result.append('\t');
        }
        return result.toString();
    }
}

