/*
 * Decompiled with CFR 0.152.
 */
package net.oneandone.mork.classfile.attribute;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import net.oneandone.mork.classfile.InnerClassesInfo;
import net.oneandone.mork.classfile.Input;
import net.oneandone.mork.classfile.Output;
import net.oneandone.mork.classfile.attribute.Attribute;

public class InnerClasses
extends Attribute {
    public static final String NAME = "InnerClasses";
    public final List<InnerClassesInfo> infos = new ArrayList<InnerClassesInfo>();

    public InnerClasses() {
        super(NAME);
    }

    public InnerClasses(Input src) throws IOException {
        this();
        int len = src.readU4();
        int count = src.readU2();
        if (2 + count * 8 != len) {
            throw new RuntimeException("InnerClasses: illegal length: count=" + count + " len=" + len);
        }
        for (int i = 0; i < count; ++i) {
            this.infos.add(new InnerClassesInfo(src));
        }
    }

    @Override
    public void write(Output dest) throws IOException {
        dest.writeUtf8(this.name);
        int start = dest.writeSpace(4);
        int len = this.infos.size();
        dest.writeU2(this.infos.size());
        for (int i = 0; i < len; ++i) {
            InnerClassesInfo info = this.infos.get(i);
            info.write(dest);
        }
        dest.writeFixup(start, dest.getGlobalOfs() - (start + 4));
    }
}

