/*
 * Decompiled with CFR 0.152.
 */
package net.oneandone.mork.classfile.attribute;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import net.oneandone.mork.classfile.Input;
import net.oneandone.mork.classfile.Output;
import net.oneandone.mork.classfile.attribute.Attribute;

public class LineNumberTable
extends Attribute {
    public static final String NAME = "LineNumberTable";
    public final List<Integer> pcs = new ArrayList<Integer>();
    public final List<Integer> lines = new ArrayList<Integer>();

    public LineNumberTable() {
        super(NAME);
    }

    public LineNumberTable(Input src) throws IOException {
        this();
        src.requireCode();
        int len = src.readU4();
        int count = src.readU2();
        if (2 + count * 4 != len) {
            throw new RuntimeException("illegal LineNumberTable attribute");
        }
        for (int i = 0; i < count; ++i) {
            this.pcs.add(src.readIdx());
            this.lines.add(Integer.valueOf(src.readU2()));
        }
    }

    @Override
    public void write(Output dest) throws IOException {
        dest.requireCode();
        dest.writeUtf8(this.name);
        int start = dest.writeSpace(4);
        int len = this.pcs.size();
        dest.writeU2(len);
        for (int i = 0; i < len; ++i) {
            dest.writeIdx(this.pcs.get(i));
            dest.writeU2(this.lines.get(i));
        }
        dest.writeFixup(start, dest.getGlobalOfs() - (start + 4));
    }

    public String toString() {
        StringBuilder result = new StringBuilder();
        result.append(NAME);
        result.append(" attribute\n");
        int len = this.pcs.size();
        for (int i = 0; i < len; ++i) {
            result.append("  " + this.pcs.get(i) + " " + this.lines.get(i));
        }
        return result.toString();
    }
}

