/*
 * Decompiled with CFR 0.152.
 */
package net.oneandone.mork.classfile.attribute;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import net.oneandone.mork.classfile.Input;
import net.oneandone.mork.classfile.LocalVariableInfo;
import net.oneandone.mork.classfile.Output;
import net.oneandone.mork.classfile.attribute.Attribute;

public class LocalVariableTable
extends Attribute {
    public static final String NAME = "LocalVariableTable";
    public final List<LocalVariableInfo> infos = new ArrayList<LocalVariableInfo>();

    public LocalVariableTable() {
        super(NAME);
    }

    public LocalVariableTable(Input src) throws IOException {
        this();
        src.requireCode();
        int len = src.readU4();
        int count = src.readU2();
        if (2 + count * 10 != len) {
            throw new RuntimeException("LocalVariableTable: illegal length: count=" + count + " len=" + len);
        }
        for (int i = 0; i < count; ++i) {
            this.infos.add(new LocalVariableInfo(src));
        }
    }

    @Override
    public void write(Output dest) throws IOException {
        dest.requireCode();
        dest.writeUtf8(this.name);
        int start = dest.writeSpace(4);
        int max = this.infos.size();
        dest.writeU2(this.infos.size());
        for (int i = 0; i < max; ++i) {
            LocalVariableInfo info = this.infos.get(i);
            info.write(dest);
        }
        dest.writeFixup(start, dest.getGlobalOfs() - (start + 4));
    }

    public String toString() {
        StringBuilder result = new StringBuilder();
        result.append("LocalTableTable\n");
        int max = this.infos.size();
        for (int i = 0; i < max; ++i) {
            result.append('\t');
            result.append(this.infos.get(i).toString());
            result.append('\n');
        }
        return result.toString();
    }
}

