/*
 * Decompiled with CFR 0.152.
 */
package net.oneandone.mork.classfile.attribute;

import java.io.IOException;
import net.oneandone.mork.classfile.Input;
import net.oneandone.mork.classfile.Output;
import net.oneandone.mork.classfile.attribute.Attribute;

public class SourceFile
extends Attribute {
    public static final String NAME = "SourceFile";
    public final String file;

    public SourceFile(String fileInit) {
        super(NAME);
        this.file = fileInit;
    }

    public SourceFile(Input src) throws IOException {
        super(NAME);
        int len = src.readU4();
        if (len != 2) {
            throw new RuntimeException("SourceFile attribute of length " + len);
        }
        this.file = src.readUtf8();
    }

    @Override
    public void write(Output dest) throws IOException {
        dest.writeUtf8(this.name);
        dest.writeU4(2);
        dest.writeUtf8(this.file);
    }

    public String toString() {
        return this.name + " attribute " + this.file;
    }
}

