/*
 * Decompiled with CFR 0.152.
 */
package net.oneandone.mork.compiler;

import java.util.ArrayList;
import java.util.List;
import net.oneandone.mork.compiler.ConflictResolver;
import net.oneandone.mork.compiler.Line;
import net.oneandone.mork.compiler.Output;
import net.oneandone.mork.grammar.Grammar;
import net.oneandone.mork.misc.GenericException;
import net.oneandone.mork.parser.Conflict;
import net.oneandone.mork.parser.ParserTable;
import net.oneandone.mork.pda.Item;
import net.oneandone.mork.pda.State;

public class ConflictHandler {
    private final Grammar grammar;
    private final List<Conflict> conflicts;
    private final List<ConflictResolver> resolvers;

    public ConflictHandler(Grammar grammar) {
        this.grammar = grammar;
        this.conflicts = new ArrayList<Conflict>();
        this.resolvers = new ArrayList<ConflictResolver>();
    }

    public char resolve(int stateId, State state, int symbol, char oldAction, char reduceAction) {
        switch (ParserTable.getAction(oldAction)) {
            case 1: {
                this.conflicts.add(new Conflict("shift-reduce", stateId, state, symbol, oldAction, reduceAction));
                return ParserTable.createValue(0, 0);
            }
            case 2: {
                return this.reduceReduceConflict(stateId, state, symbol, -1, oldAction, reduceAction);
            }
            case 0: {
                int operand = ParserTable.getOperand(oldAction);
                switch (operand & 3) {
                    case 2: {
                        return this.reduceReduceConflict(stateId, state, symbol, operand >> 2, reduceAction);
                    }
                    case 0: {
                        return oldAction;
                    }
                }
                throw new IllegalStateException();
            }
        }
        throw new IllegalStateException();
    }

    public char reduceReduceConflict(int stateId, State state, int symbol, int resolverNo, int ... newReduceActions) {
        Item i;
        ConflictResolver resolver;
        ArrayList<Item> items = new ArrayList<Item>();
        ArrayList<Integer> allReduceActions = new ArrayList<Integer>();
        if (resolverNo != -1) {
            resolver = this.resolvers.get(resolverNo);
            for (Object l : (Object)resolver.lines) {
                i = state.getReduceItem(ParserTable.getOperand(((Line)l).action));
                if (items.contains(i)) continue;
                items.add(i);
                allReduceActions.add(((Line)l).action);
            }
        }
        for (int reduceAction : newReduceActions) {
            i = state.getReduceItem(ParserTable.getOperand(reduceAction));
            if (items.contains(i)) continue;
            items.add(i);
            allReduceActions.add(reduceAction);
        }
        ArrayList<Line> lines = new ArrayList<Line>();
        Object object = items.iterator();
        while (object.hasNext()) {
            Item item = (Item)object.next();
            for (int[] terminals : item.lookahead.follows(symbol)) {
                Line line = new Line(terminals, ParserTable.createValue(2, item.getProduction()));
                Line conflicting = Line.lookupTerminals(lines, line.terminals);
                if (conflicting != null) {
                    this.conflicts.add(new Conflict("reduce-reduce", stateId, state, symbol, ConflictHandler.toArray(allReduceActions)));
                    return ParserTable.createValue(0, 0);
                }
                lines.add(line);
            }
        }
        Line[] array = new Line[lines.size()];
        lines.toArray(array);
        resolver = new ConflictResolver(array);
        if (resolverNo == -1) {
            this.resolvers.add(resolver);
            resolverNo = this.resolvers.size() - 1;
        } else {
            this.resolvers.set(resolverNo, resolver);
        }
        return ParserTable.createValue(0, 2 | resolverNo << 2);
    }

    private static int[] toArray(List<Integer> lst) {
        int[] result = new int[lst.size()];
        for (int i = 0; i < result.length; ++i) {
            result[i] = lst.get(i);
        }
        return result;
    }

    public int conflicts() {
        return this.conflicts.size();
    }

    public ConflictResolver[] report(Output output, Grammar grammar) throws GenericException {
        if (this.conflicts.size() > 0) {
            for (Conflict conflict : this.conflicts) {
                output.error("TODO", conflict.toString(grammar));
            }
            throw new GenericException("aborted with conflicts");
        }
        return this.resolvers.toArray(new ConflictResolver[this.resolvers.size()]);
    }

    public int resolvers() {
        return this.resolvers.size();
    }
}

