/*
 * Decompiled with CFR 0.152.
 */
package net.oneandone.mork.compiler;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.oneandone.mork.classfile.Bytecodes;
import net.oneandone.mork.classfile.Code;
import net.oneandone.mork.compiler.CustomCompiler;
import net.oneandone.mork.compiler.InvocationCode;
import net.oneandone.mork.reflect.Function;

public class FunctionCompiler
extends CustomCompiler
implements Bytecodes {
    private static final int MAX_SIZE = 800;
    private final String className;
    private final List<InvocationCode> classes;
    private InvocationCode current;
    private Map<Function, Object[]> done;

    public FunctionCompiler(String className) {
        this.className = className;
        this.classes = new ArrayList<InvocationCode>();
        this.current = null;
        this.done = new HashMap<Function, Object[]>();
    }

    @Override
    public boolean matches(Class<?> type) {
        return Function.class.isAssignableFrom(type);
    }

    @Override
    public void beginTranslation(Object obj, Code dest) {
        if (this.current == null) {
            this.current = new InvocationCode(this.className + (this.classes.size() + 1));
            this.classes.add(this.current);
        }
        if (!this.current.reuse((Function)obj, dest, this.done)) {
            this.current.translate((Function)obj, dest, this.done);
        }
        if (this.current.size() == 800) {
            this.current = null;
        }
    }

    @Override
    public void endTranslation(Object obj, Code dest) {
    }

    @Override
    public Class<?>[] getFieldTypes() {
        return new Class[0];
    }

    @Override
    public Object[] getFieldObjects(Object obj) {
        return new Object[0];
    }

    public void save(String fileBase) throws IOException {
        int max = this.classes.size();
        for (int i = 0; i < max; ++i) {
            this.classes.get(i).save(new File(fileBase + (i + 1) + ".class"));
        }
        this.done = null;
    }
}

