/*
 * Decompiled with CFR 0.152.
 */
package net.oneandone.mork.compiler;

import java.lang.reflect.InvocationTargetException;
import net.oneandone.mork.classfile.Bytecodes;
import net.oneandone.mork.classfile.ClassRef;
import net.oneandone.mork.classfile.Code;
import net.oneandone.mork.classfile.MethodRef;
import net.oneandone.mork.compiler.CustomCompiler;
import net.oneandone.mork.reflect.Field;
import net.oneandone.mork.reflect.Function;
import net.oneandone.mork.reflect.Method;
import net.oneandone.mork.reflect.Selection;

public class GenericCompiler
extends CustomCompiler
implements Bytecodes {
    private final Class<?> type;
    private final Function[] fields;
    private final Class<?>[] fieldTypes;
    private final MethodRef constr;
    private final int constrType;

    public GenericCompiler(Class<?> typeInit, String[] fieldNames) {
        this(typeInit, fieldNames, null);
    }

    public GenericCompiler(Class<?> typeInit, String[] fieldNames, String constrName) {
        int i;
        this.type = typeInit;
        this.fields = new Function[fieldNames.length];
        this.fieldTypes = new Class[this.fields.length];
        for (i = 0; i < this.fields.length; ++i) {
            this.fields[i] = this.findField(fieldNames[i]);
            this.fieldTypes[i] = this.fields[i].getReturnType();
        }
        if (constrName == null) {
            ClassRef[] tmp = new ClassRef[this.fields.length];
            for (i = 0; i < this.fields.length; ++i) {
                tmp[i] = new ClassRef(this.fields[i].getReturnType());
            }
            this.constr = MethodRef.constr(new ClassRef(this.type), tmp);
            this.constrType = 183;
        } else {
            this.constr = new MethodRef(this.findConstr(constrName));
            this.constrType = 184;
        }
    }

    @Override
    public boolean matches(Class<?> c) {
        return this.type.equals(c);
    }

    @Override
    public Class<?>[] getFieldTypes() {
        return this.fieldTypes;
    }

    @Override
    public Object[] getFieldObjects(Object obj) {
        Object[] result = new Object[this.fieldTypes.length];
        for (int i = 0; i < result.length; ++i) {
            try {
                result[i] = this.fields[i].invokeN(obj);
                continue;
            }
            catch (InvocationTargetException e) {
                throw new RuntimeException("can't get field: " + this.fields[i] + ": " + e);
            }
        }
        return result;
    }

    private Function findField(String name) {
        Field f;
        Selection slkt;
        if (name.indexOf(46) == -1) {
            name = this.type.getName() + "." + name;
        }
        if ((slkt = Method.forName(name)).size() == 0 && (f = Field.forName(name)) != null) {
            slkt = slkt.add(new Selection(f));
        }
        slkt = slkt.restrictArgumentCount(1);
        slkt = slkt.restrictArgumentType(0, this.type);
        switch (slkt.size()) {
            case 0: {
                throw new RuntimeException("no such field: " + name);
            }
            case 1: {
                return slkt.getFunction();
            }
        }
        throw new RuntimeException("ambiguous field: " + name);
    }

    private java.lang.reflect.Method findConstr(String name) {
        Selection slkt = Method.forName(name);
        slkt = slkt.restrictArgumentCount(this.fields.length);
        for (int i = 0; i < this.fields.length; ++i) {
            slkt.restrictArgumentType(i, this.fields[i].getReturnType());
        }
        switch (slkt.size()) {
            case 0: {
                throw new RuntimeException("no such constructor: " + name);
            }
            case 1: {
                return ((Method)slkt.getFunction()).getRaw();
            }
        }
        throw new RuntimeException("constructor ambiguous: " + name);
    }

    @Override
    public void beginTranslation(Object obj, Code dest) {
        if (this.constrType == 183) {
            dest.emit(187, new ClassRef(this.type));
            dest.emit(89);
        }
    }

    @Override
    public void endTranslation(Object obj, Code dest) {
        dest.emit(this.constrType, this.constr);
    }
}

