/*
 * Decompiled with CFR 0.152.
 */
package net.oneandone.mork.compiler;

import java.io.File;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.util.Map;
import net.oneandone.mork.classfile.Access;
import net.oneandone.mork.classfile.Bytecodes;
import net.oneandone.mork.classfile.ClassDef;
import net.oneandone.mork.classfile.ClassRef;
import net.oneandone.mork.classfile.Code;
import net.oneandone.mork.classfile.ExceptionInfo;
import net.oneandone.mork.classfile.FieldRef;
import net.oneandone.mork.classfile.MethodDef;
import net.oneandone.mork.classfile.MethodRef;
import net.oneandone.mork.classfile.Output;
import net.oneandone.mork.classfile.attribute.Exceptions;
import net.oneandone.mork.compiler.CompiledFunctionBase;
import net.oneandone.mork.compiler.Util;
import net.oneandone.mork.reflect.Function;
import net.oneandone.sushi.util.IntArrayList;

public class InvocationCode
implements Bytecodes {
    private final Code code;
    private final IntArrayList labels;
    private final int switchFixup;
    private final ClassRef destRef;
    private final MethodRef destConstr;
    private static final ClassRef THROWABLE_REF = new ClassRef(Throwable.class);
    private static final ClassRef EXCEPT_REF = new ClassRef(InvocationTargetException.class);
    private static final int LV_ARGS = 1;
    private static final int LV_THROWABLE = 2;

    public InvocationCode(String className) {
        this.destRef = new ClassRef(className);
        this.destConstr = MethodRef.constr(this.destRef, ClassRef.INT);
        this.labels = new IntArrayList();
        this.code = new Code();
        this.code.locals = 3;
        this.code.emit(25, 0);
        this.code.emit(180, new FieldRef(this.destRef, "id", ClassRef.INT));
        this.switchFixup = this.code.declareFixup();
    }

    public int size() {
        return this.labels.size();
    }

    public boolean reuse(Function fn, Code dest, Map<Function, Object[]> done) {
        Object[] obj = done.get(fn);
        if (obj == null) {
            return false;
        }
        InvocationCode.emitNew(dest, (ClassRef)obj[0], (MethodRef)obj[1], (Integer)obj[2]);
        return true;
    }

    public void translate(Function fn, Code dest, Map<Function, Object[]> done) {
        int id = this.labels.size();
        this.labels.add(this.code.currentLabel());
        Class<?>[] tmp = fn.getParameterTypes();
        for (int i = 0; i < tmp.length; ++i) {
            this.code.emit(25, 1);
            this.code.emit(18, i);
            this.code.emit(50);
            Util.unwrap(tmp[i], this.code);
        }
        fn.translate(this.code);
        this.wrap(fn.getReturnType());
        this.code.emit(176);
        InvocationCode.emitNew(dest, this.destRef, this.destConstr, id);
        done.put(fn, new Object[]{this.destRef, this.destConstr, new Integer(id)});
    }

    private static void emitNew(Code dest, ClassRef destRef, MethodRef destConstr, int id) {
        dest.emit(187, destRef);
        dest.emit(89);
        dest.emit(18, id);
        dest.emit(183, destConstr);
    }

    public void save(File file) throws IOException {
        if (this.labels.size() == 0) {
            throw new IllegalStateException("no functions defined");
        }
        int deflt = this.code.currentLabel();
        this.illegalId();
        this.code.fixup(this.switchFixup, 170, deflt, 0, this.labels.size() - 1, this.labels);
        this.exceptionHandler();
        this.save(this.code, file);
    }

    private void illegalId() {
        ClassRef except = new ClassRef(RuntimeException.class);
        this.code.emit(187, except);
        this.code.emit(89);
        this.code.emit(18, "illegal function id");
        this.code.emit(183, MethodRef.constr(except, new ClassRef[]{ClassRef.STRING}));
        this.code.emit(191);
    }

    private void exceptionHandler() {
        int pc = this.code.currentLabel();
        this.code.emit(58, 2);
        this.code.emit(187, EXCEPT_REF);
        this.code.emit(89);
        this.code.emit(25, 2);
        this.code.emit(18, "function invocation failed");
        this.code.emit(183, MethodRef.constr(EXCEPT_REF, THROWABLE_REF, ClassRef.STRING));
        this.code.emit(191);
        ExceptionInfo info = new ExceptionInfo(0, pc, pc, THROWABLE_REF);
        this.code.exceptions.add(info);
    }

    private void wrap(Class<?> cl) {
        if (cl.isPrimitive()) {
            ClassRef wrapper = new ClassRef(ClassRef.wrappedType(cl));
            this.code.emit(187, wrapper);
            if (new ClassRef(cl).operandSize() == 1) {
                this.code.emit(90);
                this.code.emit(90);
            } else {
                this.code.emit(91);
                this.code.emit(91);
            }
            this.code.emit(87);
            this.code.emit(183, MethodRef.constr(wrapper, new ClassRef[]{new ClassRef(cl)}));
        }
    }

    private void save(Code code, File file) throws IOException {
        ClassDef c = new ClassDef(this.destRef, new ClassRef(CompiledFunctionBase.class));
        c.addField(Access.fromArray(Access.PRIVATE, Access.FINAL), ClassRef.INT, "id");
        this.addConstr(c);
        MethodDef m = c.addMethod(Access.fromArray(Access.PUBLIC), ClassRef.OBJECT, "invoke", new ClassRef[]{new ClassRef("java.lang.Object", 1)}, code);
        Exceptions e = new Exceptions();
        e.exceptions.add(EXCEPT_REF);
        m.attributes.add(e);
        Output.save(c, file);
    }

    private void addConstr(ClassDef c) {
        Code code = new Code();
        code.emit(25, 0);
        code.emit(183, MethodRef.constr(new ClassRef(CompiledFunctionBase.class), ClassRef.NONE));
        code.emit(25, 0);
        code.emit(21, 1);
        code.emit(181, new FieldRef(this.destRef, "id", ClassRef.INT));
        code.emit(177);
        code.locals = 2;
        c.addConstructor(Access.fromArray(Access.PUBLIC), new ClassRef[]{ClassRef.INT}, code);
    }
}

