/*
 * Decompiled with CFR 0.152.
 */
package net.oneandone.mork.compiler;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import net.oneandone.sushi.util.Strings;

public class Job {
    public final File source;
    public final File listing;
    public final File outputPath;
    public final int k;
    public final int threadCount;
    public static final String SRC_SUFFIX = ".mapper";
    public static final String LST_SUFFIX = ".lst";

    public Job(String srcName) throws IOException {
        this(null, false, srcName);
    }

    public Job(String outputPathName, boolean listing, String srcName) throws IOException {
        this(outputPathName, 1, 1, listing, srcName);
    }

    public Job(String outputPathName, int k, int threadCount, boolean listing, String srcName) throws IOException {
        if (outputPathName == null) {
            this.outputPath = null;
        } else {
            this.outputPath = new File(outputPathName);
            if (!this.outputPath.isDirectory()) {
                throw new FileNotFoundException("no such directory: " + this.outputPath);
            }
        }
        this.k = k;
        this.threadCount = threadCount;
        this.source = new File(srcName);
        if (listing) {
            String baseName = Strings.removeRightOpt((String)this.source.getName(), (String)SRC_SUFFIX);
            this.listing = new File("target/" + baseName + LST_SUFFIX);
        } else {
            this.listing = null;
        }
    }

    public boolean equals(Object obj) {
        if (obj instanceof Job) {
            Job job = (Job)obj;
            return this.source.equals(job.source) && Job.eq(this.listing, job.listing) && Job.eq(this.outputPath, job.outputPath);
        }
        return false;
    }

    public int hashCode() {
        return this.source.hashCode();
    }

    private static boolean eq(File a, File b) {
        if (a != null) {
            return a.equals(b);
        }
        return b == null;
    }

    public String toString() {
        return "source=" + this.source + " listing=" + this.listing + " output=" + this.outputPath;
    }
}

