/*
 * Decompiled with CFR 0.152.
 */
package net.oneandone.mork.compiler;

import java.io.IOException;
import java.io.PrintWriter;
import java.util.List;
import net.oneandone.inline.Cli;
import net.oneandone.mork.compiler.Job;
import net.oneandone.mork.compiler.Mork;
import net.oneandone.mork.compiler.MorkMapper;
import net.oneandone.mork.compiler.Output;
import net.oneandone.mork.compiler.Specification;
import net.oneandone.mork.misc.GenericException;
import net.oneandone.mork.reflect.Function;

public class Main {
    private static Output redirect;
    private final boolean help;
    private final boolean verbose;
    private final boolean lst;
    private final boolean stat;
    private final String directory;
    private final int k;
    private final int threadCount;
    private final String mapper;
    private List<String> files;
    private final Output output;
    private Function mapperFn;
    public static final String USAGE = "usage: \"mork\" option* mapperfile*\noption:\n -help                 print this message and quit\n -lst                  generate mapper listing\n -d directory          sets the destination directory for class files\n -k num                number of lookahead token, default is 1\n -t num                parallel threads for pda generation, default is 1\n -stat                 print mapper statistics\n -verbose              issue overall progress information\n";

    public static void main(String[] args) {
        System.exit(Main.doMain(null, args));
    }

    public static int doMain(Output redirect, String[] args) {
        Main.redirect = redirect;
        try {
            Cli cli = new Cli();
            cli.addDefault(Main.class, "notused -help -verbose -lst -stat -d=null -k -t -mapper=null file*");
            cli.run(args);
        }
        finally {
            Main.redirect = null;
        }
        return 0;
    }

    public Main(boolean help, boolean verbose, boolean lst, boolean stat, String directory, int k, int threadCount, String mapper, List<String> files) {
        this.help = help;
        this.verbose = verbose;
        this.lst = lst;
        this.stat = stat;
        this.directory = directory;
        this.k = k;
        this.threadCount = threadCount == 0 ? Runtime.getRuntime().availableProcessors() : threadCount;
        this.mapper = mapper;
        this.files = files;
        this.output = redirect == null ? new Output() : redirect;
        this.mapperFn = null;
    }

    public Job[] jobs() {
        String errorPos = "mork";
        String outputPath = null;
        boolean listing = false;
        if (this.verbose) {
            this.output.verbose = new PrintWriter(System.out, true);
        }
        if (this.lst) {
            listing = true;
        }
        if (this.stat) {
            this.output.statistics = new PrintWriter(System.out, true);
        }
        if (this.directory != null) {
            outputPath = this.directory;
        }
        if (this.mapper != null) {
            try {
                this.mapperFn = MorkMapper.lookupMapperFn(this.mapper, Specification.class);
            }
            catch (GenericException e) {
                this.output.error(errorPos, e);
            }
        }
        Job[] jobs = new Job[this.files.size()];
        for (int j = 0; j < jobs.length; ++j) {
            try {
                jobs[j] = new Job(outputPath, this.k, this.threadCount, listing, this.files.get(j));
                continue;
            }
            catch (IOException e) {
                this.output.error(errorPos, e.getMessage());
                return null;
            }
        }
        return jobs;
    }

    public void printHelp() {
        this.output.normal("Mork compiler tool, version " + this.getVersion());
        this.output.normal("");
        this.output.normal(USAGE);
    }

    public String getVersion() {
        Package p = this.getClass().getPackage();
        if (p == null) {
            return "(unknown)";
        }
        return p.getSpecificationVersion() + " (" + p.getImplementationVersion() + ")";
    }

    public void run() throws Exception {
        if (this.help || this.files.size() == 0) {
            this.printHelp();
            return;
        }
        Job[] jobs = this.jobs();
        Mork mork = new Mork(this.output, this.mapperFn);
        for (int i = 0; i < jobs.length; ++i) {
            if (mork.compile(jobs[i])) continue;
            throw new IOException("compile error");
        }
    }
}

