/*
 * Decompiled with CFR 0.152.
 */
package net.oneandone.mork.compiler;

import java.io.File;
import java.io.IOException;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import net.oneandone.mork.classfile.Access;
import net.oneandone.mork.classfile.Bytecodes;
import net.oneandone.mork.classfile.ClassDef;
import net.oneandone.mork.classfile.ClassRef;
import net.oneandone.mork.classfile.Code;
import net.oneandone.mork.compiler.ConflictResolver;
import net.oneandone.mork.compiler.CustomCompiler;
import net.oneandone.mork.compiler.FunctionCompiler;
import net.oneandone.mork.compiler.GenericCompiler;
import net.oneandone.mork.compiler.Line;
import net.oneandone.mork.compiler.ObjectCompiler;
import net.oneandone.mork.compiler.Output;
import net.oneandone.mork.grammar.Rule;
import net.oneandone.mork.mapping.Mapper;
import net.oneandone.mork.misc.StringArrayList;
import net.oneandone.mork.parser.Parser;
import net.oneandone.mork.parser.ParserTable;
import net.oneandone.mork.scanner.ScannerFactory;
import net.oneandone.mork.semantics.Attribution;
import net.oneandone.mork.semantics.Oag;
import net.oneandone.mork.semantics.Visits;
import net.oneandone.sushi.util.IntArrayList;
import net.oneandone.sushi.util.IntBitSet;

public class MapperCompiler
implements Bytecodes {
    private Output output;
    private static final CustomCompiler[] customs = new CustomCompiler[]{null, new GenericCompiler(Rule.class, new String[]{"left", "right"}), new GenericCompiler(ParserTable.class, new String[]{"startState", "symbolCount", "eofSymbol", "getStateCount", "packValues", "lengths", "lefts", "modes"}), new GenericCompiler(ConflictResolver.class, new String[]{"lines"}), new GenericCompiler(Line.class, new String[]{"terminals", "action"}), new GenericCompiler(Attribution.class, new String[]{"function", "resultOfs", "resultAttr", "argsOfs", "argsAttr"}), new GenericCompiler(Oag.class, new String[]{"visits", "internalAttrs"}), new GenericCompiler(Visits.class, new String[]{"visits"}), new GenericCompiler(Parser.class, new String[]{"table", "resolvers", "scannerFactory"}), new GenericCompiler(ScannerFactory.class, new String[]{"start", "modeCount", "table"}), new GenericCompiler(IntBitSet.class, new String[]{"data"}), new GenericCompiler(IntArrayList.class, new String[]{"size", "data"}), new GenericCompiler(StringArrayList.class, new String[]{"size", "data"}), new GenericCompiler(Integer.class, new String[]{"net.oneandone.mork.compiler.MapperCompiler.saveInteger"}, "net.oneandone.mork.compiler.MapperCompiler.loadInteger"), new GenericCompiler(Class.class, new String[]{"net.oneandone.mork.compiler.MapperCompiler.saveClass"}, "net.oneandone.mork.compiler.MapperCompiler.loadClass"), new GenericCompiler(Constructor.class, new String[]{"getDeclaringClass", "getParameterTypes"}, "net.oneandone.mork.compiler.MapperCompiler.loadConstructor"), new GenericCompiler(Method.class, new String[]{"getDeclaringClass", "getName", "getParameterTypes"}, "net.oneandone.mork.compiler.MapperCompiler.loadMethod"), new GenericCompiler(Field.class, new String[]{"getDeclaringClass", "getName"}, "net.oneandone.mork.compiler.MapperCompiler.loadField")};

    public MapperCompiler(Output output) {
        this.output = output;
    }

    public void run(Mapper mapper, String mapperName, File src, File explicitOutputDir) throws IOException {
        String baseName = mapperName.substring(mapperName.lastIndexOf(46) + 1);
        File outputDir = this.outputDir(src, explicitOutputDir, mapperName);
        String mapperClassName = mapperName;
        File mapperFile = new File(outputDir, baseName + ".class");
        String functionClassName = mapperName + "Functions";
        String functionFileBase = new File(outputDir, baseName + "Functions").getPath();
        FunctionCompiler fc = new FunctionCompiler(functionClassName);
        MapperCompiler.customs[0] = fc;
        this.output.verbose("translating " + mapperClassName);
        ClassDef c = this.translate(mapper, mapperClassName);
        this.output.verbose("writing " + mapperFile);
        try {
            net.oneandone.mork.classfile.Output.save(c, mapperFile);
        }
        catch (IOException e) {
            this.output.error(mapperFile.toString(), "write failed: " + e);
        }
        try {
            fc.save(functionFileBase);
        }
        catch (IOException e) {
            this.output.error(functionFileBase.toString(), "write failed: " + e);
        }
        this.output.verbose("done");
    }

    public File outputDir(File src, File explicitOutputDir, String mapperName) throws IOException {
        File outputDir;
        if (explicitOutputDir == null) {
            outputDir = src.getParentFile();
        } else {
            outputDir = explicitOutputDir;
            int idx = mapperName.indexOf(46);
            int prev = 0;
            while (idx != -1) {
                File subDir = new File(outputDir, mapperName.substring(prev, idx));
                if (!subDir.isDirectory() && !subDir.mkdir()) {
                    throw new IOException("cannot create directory: " + subDir);
                }
                prev = idx + 1;
                idx = mapperName.indexOf(46, prev);
                outputDir = subDir;
            }
        }
        return outputDir;
    }

    private ClassDef translate(Mapper mapper, String className) {
        Code code = new Code();
        code.locals = 1;
        ClassDef result = this.createClass(className, code);
        ObjectCompiler compiler = new ObjectCompiler(code, code.allocate(ClassRef.INT), customs, result);
        code.emit(18, 2);
        code.emit(189, ClassRef.OBJECT);
        code.emit(89);
        code.emit(18, 0);
        compiler.run(mapper.getParser());
        code.emit(83);
        code.emit(89);
        code.emit(18, 1);
        compiler.run(mapper.getSemantics());
        code.emit(83);
        code.emit(176);
        return result;
    }

    private ClassDef createClass(String className, Code code) {
        ClassDef result = new ClassDef(new ClassRef(className), ClassRef.OBJECT);
        result.addMethod(Access.fromArray(Access.PUBLIC, Access.STATIC), ClassRef.OBJECT, "load", ClassRef.NONE, code);
        return result;
    }

    public static int saveInteger(Integer i) {
        return i;
    }

    public static Integer loadInteger(int i) {
        return new Integer(i);
    }

    public static String saveClass(Class<?> c) {
        return new ClassRef(c).toFieldDescriptor();
    }

    public static Class<?> loadClass(String name) {
        return ClassRef.forFieldDescriptor(name).lookup();
    }

    public static Field loadField(Class<?> type, String name) throws NoSuchFieldException {
        return type.getDeclaredField(name);
    }

    public static Constructor<?> loadConstructor(Class<?> type, Class<?>[] args) throws NoSuchMethodException {
        return type.getDeclaredConstructor(args);
    }

    public static Method loadMethod(Class<?> type, String name, Class<?>[] args) throws NoSuchMethodException {
        return type.getDeclaredMethod(name, args);
    }
}

