/*
 * Decompiled with CFR 0.152.
 */
package net.oneandone.mork.compiler;

import java.io.File;
import java.io.IOException;
import net.oneandone.mork.compiler.Job;
import net.oneandone.mork.compiler.MapperCompiler;
import net.oneandone.mork.compiler.MorkMapper;
import net.oneandone.mork.compiler.Output;
import net.oneandone.mork.compiler.Specification;
import net.oneandone.mork.compiler.Syntax;
import net.oneandone.mork.mapping.Mapper;
import net.oneandone.mork.misc.GenericException;
import net.oneandone.mork.reflect.Function;
import net.oneandone.mork.semantics.BuiltIn;
import net.oneandone.mork.semantics.IllegalLiteral;

public class Mork {
    public final Output output;
    private final MorkMapper mapperMapper;
    private final MorkMapper syntaxMapper;
    private final MapperCompiler compiler;
    private Job currentJob;

    public Mork(Output output, Function mapperFn) {
        this.output = output;
        this.mapperMapper = new MorkMapper(this, "net.oneandone.mork.compiler.MapperMapper", mapperFn);
        this.syntaxMapper = new MorkMapper(this, "net.oneandone.mork.compiler.SyntaxMapper");
        this.compiler = new MapperCompiler(output);
        this.currentJob = null;
    }

    public boolean compile(Job job) throws IOException {
        this.currentJob = job;
        boolean result = this.compileCurrent();
        this.currentJob = null;
        return result;
    }

    private boolean compileCurrent() throws IOException {
        Specification spec;
        this.output.normal(this.currentJob.source + ":");
        if (this.currentJob.listing != null) {
            this.output.openListing(this.currentJob.listing);
        }
        if ((spec = (Specification)this.mapperMapper.invoke(this.currentJob.source)) == null) {
            return false;
        }
        try {
            Mapper result = spec.translate(this.currentJob.k, this.currentJob.threadCount, this.output);
            this.compiler.run(result, spec.getMapperName(), this.currentJob.source, this.currentJob.outputPath);
        }
        catch (GenericException e) {
            this.output.error(this.currentJob.source.getName(), e);
            return false;
        }
        catch (IOException e) {
            this.output.error(this.currentJob.source.getName(), e.getMessage());
            return false;
        }
        return true;
    }

    public Syntax loadSyntax(String fileName) throws GenericException, IllegalLiteral, IOException {
        return this.loadSyntax(fileName, this.syntaxMapper);
    }

    private Syntax loadSyntax(String fileName, MorkMapper mapper) throws GenericException, IllegalLiteral, IOException {
        fileName = BuiltIn.parseString(fileName);
        fileName = fileName.replace('/', File.separatorChar);
        File file = Mork.absoluteFile(this.currentJob.source.getParentFile(), fileName);
        Syntax syntax = (Syntax)mapper.invoke(file);
        if (syntax == null) {
            throw new GenericException("error(s) in syntax file - aborted");
        }
        return syntax;
    }

    public static File absoluteFile(File dir, String fileName) {
        File file = new File(fileName);
        if (file.isAbsolute()) {
            return file;
        }
        return new File(dir, fileName);
    }
}

