/*
 * Decompiled with CFR 0.152.
 */
package net.oneandone.mork.compiler;

import java.io.File;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import net.oneandone.mork.compiler.Mork;
import net.oneandone.mork.compiler.Specification;
import net.oneandone.mork.mapping.Mapper;
import net.oneandone.mork.misc.GenericException;
import net.oneandone.mork.reflect.Function;
import net.oneandone.mork.reflect.Method;
import net.oneandone.mork.reflect.Selection;

public class MorkMapper
extends Mapper {
    private final Mork mork;
    private final Function mapperFn;

    public MorkMapper(Mork mork, String mapperName) {
        this(mork, mapperName, null);
    }

    public MorkMapper(Mork mork, String mapperName, Function mapperFn) {
        super(mapperName);
        this.mork = mork;
        this.mapperFn = mapperFn;
        this.setEnvironment(mork);
        this.setErrorHandler(mork.output);
    }

    public Object invoke(File source) throws IOException {
        if (this.mapperFn != null) {
            return this.invokeMapperFn(source.getPath());
        }
        return this.invokeMapper(source);
    }

    private Object invokeMapper(File source) throws IOException {
        String name = source.getPath();
        this.mork.output.verbose("mapping " + name);
        Object[] results = this.run(name);
        this.mork.output.verbose("finished mapping " + name);
        if (results == null) {
            return null;
        }
        return results[0];
    }

    private Object invokeMapperFn(String source) {
        Specification result;
        try {
            result = (Specification)this.mapperFn.invokeN(source);
        }
        catch (InvocationTargetException e) {
            Throwable te = e.getTargetException();
            if (te instanceof RuntimeException) {
                throw (RuntimeException)te;
            }
            if (te instanceof Error) {
                throw (Error)te;
            }
            te.printStackTrace();
            throw new RuntimeException("unexpected checked exception: " + te.getClass().getName() + ": " + te.getMessage());
        }
        return result;
    }

    public static Function lookupMapperFn(String name, Class<?> resultType) throws GenericException {
        Class<?>[] tmp;
        Selection selection = Method.forName(name);
        if (selection.isEmpty()) {
            throw new GenericException("no such method: " + name);
        }
        selection = selection.restrictArgumentCount(1);
        Function fn = (selection = selection.restrictArgumentType(0, String.class)).getFunction();
        if (fn == null) {
            throw new GenericException("argument type mismatch: 1 string argument expected: " + name);
        }
        if (!resultType.isAssignableFrom(fn.getReturnType())) {
            throw new GenericException("return type mismatch, expected: " + resultType.getName());
        }
        for (Class<?> c : tmp = fn.getExceptionTypes()) {
            if (RuntimeException.class.isAssignableFrom(c) || Error.class.isAssignableFrom(c)) continue;
            throw new GenericException("mapper method must not throw checked exception: " + c);
        }
        return fn;
    }
}

