/*
 * Decompiled with CFR 0.152.
 */
package net.oneandone.mork.compiler;

import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import net.oneandone.mork.classfile.Access;
import net.oneandone.mork.classfile.Bytecodes;
import net.oneandone.mork.classfile.ClassDef;
import net.oneandone.mork.classfile.ClassRef;
import net.oneandone.mork.classfile.Code;
import net.oneandone.mork.classfile.Constants;
import net.oneandone.mork.classfile.MethodRef;
import net.oneandone.mork.compiler.CustomCompiler;
import net.oneandone.mork.reflect.Arrays;

public class ObjectCompiler
implements Bytecodes,
Constants {
    private Code dest;
    private final CustomCompiler[] customs;
    private final int buffer;
    private final ClassDef destClass;
    private final List<Object> stack;
    private int helperMethods;
    public static final int MAX_INSTRUCTIONS = 16000;
    public static final int MIN_INSTRUCTIONS = 5;
    private static final int CHUNK = 16384;
    private static final MethodRef GET_CHARS = MethodRef.meth(ClassRef.STRING, ClassRef.VOID, "getChars", ClassRef.INT, ClassRef.INT, new ClassRef("char", 1), ClassRef.INT);

    public ObjectCompiler(Code dest, int buffer, CustomCompiler[] customs, ClassDef destClass) {
        this.dest = dest;
        this.buffer = buffer;
        this.customs = customs;
        this.destClass = destClass;
        this.stack = new ArrayList<Object>();
        this.helperMethods = 0;
    }

    public void run(Object obj) {
        if (obj == null) {
            this.run(Object.class, null, 16000);
        } else {
            this.run(obj.getClass(), obj, 16000);
        }
    }

    private void run(Class<?> type, Object val, int limit) {
        int initial = this.dest.getSize();
        if (val == null) {
            if (type.isPrimitive()) {
                throw new IllegalArgumentException("primitive null");
            }
            this.dest.emit(18, (String)null);
        } else if (val instanceof String) {
            this.dest.emit(18, (String)val);
        } else if (type.isPrimitive()) {
            this.primitive(ClassRef.findComponent(type).id, val);
        } else if (type.isArray()) {
            this.array(type, val, limit);
        } else {
            this.object(type, val, limit);
        }
        if (this.dest.getSize() - initial > limit) {
            throw new IllegalStateException("limit:" + limit + " used:" + (this.dest.getSize() - initial) + " val:" + val);
        }
    }

    private void primitive(int typeCode, Object obj) {
        switch (typeCode) {
            case 4: {
                this.dest.emit(18, (Boolean)obj != false ? 1 : 0);
                break;
            }
            case 5: {
                this.dest.emit(18, ((Character)obj).charValue());
                break;
            }
            case 8: 
            case 9: {
                this.dest.emit(18, ((Number)obj).intValue());
                break;
            }
            case 6: 
            case 7: 
            case 10: 
            case 11: {
                this.dest.emitGeneric(18, new Object[]{obj});
                break;
            }
            default: {
                throw new IllegalArgumentException("not supported: " + typeCode);
            }
        }
    }

    private void array(Class<?> type, Object ar, int limit) {
        Class<?> compType = type.getComponentType();
        if (compType.equals(Character.TYPE)) {
            this.charArray((char[])ar, limit);
        } else {
            this.nonCharArray(compType, ar, limit);
        }
    }

    private void nonCharArray(Class<?> compType, Object ar, int limit) {
        Object comp;
        int i;
        int instrPerElement = 4;
        int initialLimit = limit;
        int initialSize = this.dest.getSize();
        ClassRef compTypeRef = new ClassRef(compType);
        int len = Array.getLength(ar);
        int nonNulls = 0;
        for (i = 0; i < len; ++i) {
            comp = Array.get(ar, i);
            if (compTypeRef.isArrayDefaultElement(comp)) continue;
            ++nonNulls;
        }
        int maxLen = 2 + nonNulls * instrPerElement;
        if (limit < maxLen) {
            this.pushMethod(Arrays.getArrayClass(compType));
            if (1 + nonNulls * instrPerElement > 16000) {
                throw new IllegalStateException("array size ...");
            }
            this.nonCharArray(compType, ar, 16000);
            this.popMethod();
            return;
        }
        this.dest.emit(18, len);
        compTypeRef.emitArrayNew(this.dest);
        limit -= 2;
        for (i = 0; i < len; ++i) {
            comp = Array.get(ar, i);
            if (compTypeRef.isArrayDefaultElement(comp)) continue;
            this.dest.emit(89);
            this.dest.emit(18, i);
            int oldSize = this.dest.getSize();
            int localLimit = (limit -= 2) - 1 - --nonNulls * instrPerElement;
            this.run(compType, comp, localLimit);
            int used = this.dest.getSize() - oldSize;
            if (used > localLimit) {
                throw new IllegalStateException("used:" + used + " localLimit:" + localLimit + " comp:" + comp);
            }
            limit -= used;
            compTypeRef.emitArrayStore(this.dest);
            --limit;
        }
        if (nonNulls != 0) {
            throw new IllegalStateException();
        }
        if (limit < 0) {
            throw new IllegalStateException();
        }
        if (this.dest.getSize() - initialSize > initialLimit) {
            throw new IllegalStateException();
        }
    }

    private void charArray(char[] vals, int limit) {
        int instrsPerChunk = 6;
        int left = 0;
        int len = vals.length;
        int maxLen = 3 + (len / 16384 + 1) * instrsPerChunk + 1;
        if (limit < maxLen) {
            this.pushMethod(Character.TYPE);
            if (limit < maxLen) {
                throw new IllegalStateException("array size ...");
            }
            this.charArray(vals, 16000);
            this.popMethod();
            return;
        }
        this.dest.emit(18, len);
        ClassRef.CHAR.emitArrayNew(this.dest);
        this.dest.emit(58, this.buffer);
        while (left < len) {
            char c = vals[left];
            if (c != '\u0000') {
                int used;
                int right = Math.min(len, left + 16384);
                for (used = right - left; used > 0 && vals[left + used - 1] == '\u0000'; --used) {
                }
                if (used <= 0) continue;
                String str = String.copyValueOf(vals, left, used);
                this.dest.emit(18, str);
                this.dest.emit(18, 0);
                this.dest.emit(18, used);
                this.dest.emit(25, this.buffer);
                this.dest.emit(18, left);
                this.dest.emit(182, GET_CHARS);
                left = right;
                continue;
            }
            ++left;
        }
        this.dest.emit(25, this.buffer);
    }

    private void object(Class<?> type, Object obj, int limit) {
        int initialSize = this.dest.getSize();
        int initialLimit = limit;
        CustomCompiler decl = this.findDecl(obj.getClass());
        Class<?>[] types = decl.getFieldTypes();
        Object[] objects = decl.getFieldObjects(obj);
        if (limit < 5 + types.length * 1 + 5) {
            this.pushMethod(type);
            this.object(type, obj, 16000);
            this.popMethod();
            return;
        }
        int oldSize = this.dest.getSize();
        decl.beginTranslation(obj, this.dest);
        int used = this.dest.getSize() - oldSize;
        if (used > 5) {
            throw new IllegalStateException();
        }
        limit -= used;
        for (int i = 0; i < types.length; ++i) {
            int localLimit = limit - (types.length - i - 1) - 5;
            oldSize = this.dest.getSize();
            this.run(types[i], objects[i], localLimit);
            used = this.dest.getSize() - oldSize;
            if (used > localLimit) {
                throw new IllegalStateException("used:" + used + " localLimit:" + localLimit + " ele:" + objects[i]);
            }
            limit -= used;
        }
        if (limit < 5) {
            throw new IllegalStateException();
        }
        oldSize = this.dest.getSize();
        decl.endTranslation(obj, this.dest);
        if (this.dest.getSize() - oldSize > 5) {
            throw new IllegalStateException();
        }
        if (this.dest.getSize() - initialSize > initialLimit) {
            throw new IllegalStateException();
        }
    }

    private CustomCompiler findDecl(Class<?> type) {
        for (int i = 0; i < this.customs.length; ++i) {
            if (!this.customs[i].matches(type)) continue;
            return this.customs[i];
        }
        throw new RuntimeException("decl not found: " + type);
    }

    private void pushMethod(Class<?> returnTypeClass) {
        ClassRef returnType = new ClassRef(returnTypeClass);
        String name = "helper" + this.helperMethods;
        ++this.helperMethods;
        Code nextDest = new Code();
        nextDest.locals = this.buffer + 1;
        this.destClass.addMethod(new HashSet<Access>(java.util.Arrays.asList(Access.PRIVATE, Access.STATIC)), returnType, name, ClassRef.NONE, nextDest);
        MethodRef ref = new MethodRef(this.destClass.thisClass, false, returnType, name, ClassRef.NONE);
        this.dest.emit(184, ref);
        this.stack.add(this.dest);
        this.dest = nextDest;
    }

    private void popMethod() {
        this.dest.emit(176);
        this.dest = (Code)this.stack.remove(this.stack.size() - 1);
    }
}

