/*
 * Decompiled with CFR 0.152.
 */
package net.oneandone.mork.compiler;

import java.util.ArrayList;
import java.util.List;
import net.oneandone.mork.compiler.Output;
import net.oneandone.mork.compiler.Syntax;
import net.oneandone.mork.mapping.Definition;
import net.oneandone.mork.mapping.Mapper;
import net.oneandone.mork.mapping.Path;
import net.oneandone.mork.mapping.Transport;
import net.oneandone.mork.misc.GenericException;
import net.oneandone.mork.parser.Parser;
import net.oneandone.mork.semantics.Ag;
import net.oneandone.mork.semantics.Attribute;
import net.oneandone.mork.semantics.Oag;
import net.oneandone.sushi.util.IntBitSet;

public class Specification {
    private final Syntax syntax;
    private final Transport transport;
    private final Definition[] definitions;
    private final IntBitSet mainBorder;
    private final String mapperName;
    private final List<Definition> mainDefs;

    public Specification(String mapperName, Syntax syntax, Definition[] definitions) {
        this.mapperName = mapperName;
        this.definitions = definitions;
        this.syntax = syntax;
        this.transport = new Transport();
        this.mainBorder = new IntBitSet();
        this.mainDefs = new ArrayList<Definition>();
        for (int i = 0; i < definitions.length; ++i) {
            Definition d = definitions[i];
            Attribute a = d.getAttribute();
            this.mainBorder.add(a.symbol);
            if (!d.isMain()) continue;
            this.mainDefs.add(d);
        }
    }

    public Syntax getSyntax() {
        return this.syntax;
    }

    public Transport getTransport() {
        return this.transport;
    }

    public void translateDefaultPushPath(Definition seed) throws GenericException {
        Path.translate(this.syntax, seed, 3, this.mainBorder, this.mainDefs, 1);
    }

    public Definition lookup(String name) {
        return this.lookup(-1, name);
    }

    public Definition lookup(int symbol, String name) {
        for (int i = 0; i < this.definitions.length; ++i) {
            Definition d = this.definitions[i];
            Attribute a = d.getAttribute();
            if (!name.equals(a.name) || a.symbol != symbol && symbol != -1) continue;
            return d;
        }
        return null;
    }

    public String getMapperName() {
        return this.mapperName;
    }

    public Mapper translate(int k, int threadCount, Output output) throws GenericException {
        Parser parser = this.syntax.translate(k, threadCount, output);
        output.verbose("processing mapping section");
        Ag semanticsBuffer = new Ag(this.syntax.getGrammar());
        for (int i = 0; i < this.definitions.length; ++i) {
            this.definitions[i].translate(semanticsBuffer, this.transport, this.syntax.getGrammar());
        }
        output.verbose("computing oag");
        Oag oag = semanticsBuffer.createSemantics(this.getDefinitionAttrs(this.syntax.getGrammar().getStart()));
        output.verbose("oag done");
        if (output.statistics != null) {
            output.statistics.println();
            output.statistics.println("Semantics statistics");
            output.statistics.println("  semantics: TODO");
        }
        if (output.listing != null) {
            output.listing("\n\nAttribute Grammar\n");
            output.listing(semanticsBuffer.toString());
            output.listing.println("Visit sequences");
            oag.printVisits(output.listing);
        }
        return new Mapper(this.mapperName, parser, oag);
    }

    private List<Attribute> getDefinitionAttrs(int symbol) {
        ArrayList<Attribute> lst = new ArrayList<Attribute>();
        for (int i = 0; i < this.definitions.length; ++i) {
            Attribute a = this.definitions[i].getAttribute();
            if (a.symbol != symbol) continue;
            lst.add(a);
        }
        return lst;
    }
}

